package com.envisioniot.enos.enosapi.api.request.assetservice;

import com.envisioniot.enos.enosapi.common.response.EnOSResponse;
import java.util.List;
import com.envisioniot.enos.enosapi.api.resource.assetservice.Node;
import java.lang.String;
import com.envisioniot.enos.enosapi.common.annotation.*;
import com.envisioniot.enos.enosapi.common.enumeration.*;
import com.envisioniot.enos.enosapi.common.request.*;
import com.envisioniot.enos.enosapi.common.exception.*;

import java.util.*;

public class SearchNodePathByAssetIdRequest extends EnOSRequest<EnOSResponse<List<List<Node>>>> {
    private static final String API_METHOD = "/assetService/assetTree/traverse";
    private static final String REQUEST_METHOD = "GET";
    
    private String orgId;
    
    private String assetTreeId;
    
    private String assetId;
    
    private String pathLength;
    
    private String direction;

    public SearchNodePathByAssetIdRequest(String orgId, String assetTreeId, String assetId, String pathLength, String direction) {
        this.orgId = orgId;
        this.assetTreeId = assetTreeId;
        this.assetId = assetId;
        this.pathLength = pathLength;
        this.direction = direction;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public String getRequestMethod() {
        return REQUEST_METHOD;
    }

    @Override
    public void check() throws EnOSRuleException {
        // super.check();
    }
}