package com.envisioniot.enos.enosapi.api.request.connectservice;

import com.envisioniot.enos.enosapi.api.resource.connectservice.Event;
import com.envisioniot.enos.enosapi.api.resource.modelservice.ThingModel;
import com.envisioniot.enos.enosapi.common.exception.EnOSRuleException;
import com.envisioniot.enos.enosapi.common.request.EnOSRequest;
import com.envisioniot.enos.enosapi.common.response.EnOSResponse;

public class GetEventRequest extends EnOSRequest<EnOSResponse<Event>> {
    private static final String API_METHOD = "/connectService/event/get";
    private static final String REQUEST_METHOD = "GET";
    private String orgId;
    private String id;

    public GetEventRequest() {
    }

    public GetEventRequest(String orgId, String id) {
        this.orgId = orgId;
        this.id = id;
    }

    public static String getApiMethod() {
        return API_METHOD;
    }

    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public String getRequestMethod() {
        return REQUEST_METHOD;
    }

    @Override
    public void check() throws EnOSRuleException {
        // super.check();
    }
}
