package com.envisioniot.enos.enosapi.api.request.connectservice;

import com.envisioniot.enos.enosapi.api.resource.connectservice.Event;
import com.envisioniot.enos.enosapi.common.annotation.EnOSRequestBody;
import com.envisioniot.enos.enosapi.common.exception.EnOSRuleException;
import com.envisioniot.enos.enosapi.common.request.EnOSRequest;
import com.envisioniot.enos.enosapi.common.response.EnOSPage;
import com.envisioniot.enos.enosapi.common.response.EnOSResponse;

public class SearchEventRequest extends EnOSRequest<EnOSResponse<EnOSPage<Event>>> {

    private static final String API_METHOD = "/connectService/event/search";
    private static final String REQUEST_METHOD = "POST";

    private String orgId;
    @EnOSRequestBody
    private EventSearchParameter eventQueryParameter;

    public SearchEventRequest(EventSearchParameter eventQueryParameter, String orgId) {
        this.eventQueryParameter = eventQueryParameter;
        this.orgId = orgId;
    }

    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public EventSearchParameter getEventQueryParameter() {
        return eventQueryParameter;
    }

    public void setEventQueryParameter(EventSearchParameter eventQueryParameter) {
        this.eventQueryParameter = eventQueryParameter;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public String getRequestMethod() {
        return REQUEST_METHOD;
    }

    @Override
    public void check() throws EnOSRuleException {
        // super.check();
    }
}
