package com.envisioniot.enos.enosapi.api.request.dataservice;

import com.envisioniot.enos.enosapi.common.response.EnOSResponse;
import java.util.Map;
import java.lang.Object;
import java.lang.String;
import java.lang.Integer;
import com.envisioniot.enos.enosapi.common.response.EnOSPage;
import com.envisioniot.enos.enosapi.common.annotation.*;
import com.envisioniot.enos.enosapi.common.enumeration.*;
import com.envisioniot.enos.enosapi.common.request.*;
import com.envisioniot.enos.enosapi.common.exception.*;

import java.util.*;

public class FilterAssetsLatestDataRequest extends EnOSRequest<EnOSResponse<EnOSPage<Map<String, Object>>>> {
    private static final String API_METHOD = "/dataService/assets/latest/measurepoint/filter";
    private static final String REQUEST_METHOD = "GET";
    
    private String orgId;
    
    private String assetIds;
    
    private String modelId;
    
    private String measurepoint;
    
    private Integer timeWindow;
    
    private String operator;
    
    private String valueFilter;

    public FilterAssetsLatestDataRequest(String orgId, String assetIds, String modelId, String measurepoint, Integer timeWindow, String operator, String valueFilter) {
        this.orgId = orgId;
        this.assetIds = assetIds;
        this.modelId = modelId;
        this.measurepoint = measurepoint;
        this.timeWindow = timeWindow;
        this.operator = operator;
        this.valueFilter = valueFilter;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public String getRequestMethod() {
        return REQUEST_METHOD;
    }

    @Override
    public void check() throws EnOSRuleException {
        // super.check();
    }
}