package com.envisioniot.enos.enosapi.api.request.mdmService;/**
 * Created by zhz on 2019/4/17.
 */

import com.envisioniot.enos.enosapi.api.resource.iamservice.Policy;
import com.envisioniot.enos.enosapi.common.annotation.EnOSPathVariable;
import com.envisioniot.enos.enosapi.common.exception.EnOSRuleException;
import com.envisioniot.enos.enosapi.common.request.EnOSRequest;
import com.envisioniot.enos.enosapi.common.response.EnOSResponse;

import java.util.Map;

/**
 * @author zhz
 * @description MdmPointMappingGetRequest
 * @date 2019/4/17
 */
public class MdmPointMappingGetRequest extends EnOSRequest<EnOSResponse<Map<String, Map<String,Integer>>>> {
    private static final String API_METHOD = "/mdmService/getDomainPointMapping";
    private static final String REQUEST_METHOD = "GET";

    private String orgId;

    private String mdmids;

    private String points;

    public MdmPointMappingGetRequest(String mdmids, String points,String orgId) {
        this.mdmids = mdmids;
        this.points = points;
        this.orgId = orgId;
    }

    @Override
    public String getApiMethodName() {
        return API_METHOD;
    }

    @Override
    public String getRequestMethod() {
        return REQUEST_METHOD;
    }

    @Override
    public void check() throws EnOSRuleException {
        // super.check();
    }
}
