/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.enosapi.sdk.client;

import com.envisioniot.enos.enosapi.common.enumeration.TransferType;
import com.envisioniot.enos.enosapi.common.exception.EnOSApiException;
import com.envisioniot.enos.enosapi.common.exception.EnOSClientException;
import com.envisioniot.enos.enosapi.common.request.EnOSRequest;
import com.envisioniot.enos.enosapi.common.resource.EnOSTransferFileInfo;
import com.envisioniot.enos.enosapi.common.response.EnOSResponse;
import com.envisioniot.enos.enosapi.common.util.EnOSErrorCode;
import com.envisioniot.enos.enosapi.common.util.FileUtil;
import com.envisioniot.enos.enosapi.common.util.JsonParser;
import com.envisioniot.enos.enosapi.sdk.client.EnOSClient;
import com.envisioniot.enos.enosapi.sdk.enums.SignMethods;
import com.envisioniot.enos.enosapi.sdk.util.HttpResponseResult;
import com.envisioniot.enos.enosapi.sdk.util.JacksonUtil;
import com.envisioniot.enos.enosapi.sdk.util.Sign;
import com.envisioniot.enos.enosapi.sdk.util.WebUtils;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnOSDefaultClient
implements EnOSClient {
    private static Logger logger = LoggerFactory.getLogger(EnOSDefaultClient.class);
    private String serverUrl;
    private String accessKey;
    private String secretKey;
    private int connectTimeout = 30000;
    private int readTimeout = 30000;
    private SignMethods signMethod = SignMethods.SHA_256;

    public EnOSDefaultClient(String serverUrl, String accessKey, String secretKey) {
        this.serverUrl = serverUrl;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    public EnOSDefaultClient(String serverUrl, String accessKey, String secretKey, int connectTimeout, int readTimeout) {
        this.serverUrl = serverUrl;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public void setSignMethod(SignMethods signMethod) {
        this.signMethod = signMethod;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @Override
    public <T extends EnOSResponse> T execute(EnOSRequest<T> request) throws EnOSApiException {
        return this.doExecute(request, null);
    }

    @Override
    public <T extends EnOSResponse> T execute(EnOSRequest<T> request, Long requestTimestamp) throws EnOSApiException {
        return this.doExecute(request, requestTimestamp);
    }

    protected <T extends EnOSResponse> T doExecute(EnOSRequest<T> request, Long requestTimestamp) throws EnOSApiException {
        EnOSResponse response = null;
        try {
            request.check();
            response = (EnOSResponse)this.doRequest(request, requestTimestamp);
        }
        catch (EnOSClientException e) {
            EnOSErrorCode errorCode = e.getEnosStatus();
            String subMsg = EnOSErrorCode.CLIENT_ERROR.getMsg(new String[0]);
            if (e.getErrMsg() != null) {
                subMsg = subMsg + ": " + e.getErrMsg();
            }
            if (errorCode == null) {
                errorCode = EnOSErrorCode.CLIENT_ERROR;
            }
            logger.error(subMsg);
            response = new EnOSResponse();
            response.setStatus(errorCode.getCode());
            response.setMsg(errorCode.getMsg(new String[0]));
            response.setSubmsg(subMsg);
        }
        logger.info("result:" + JsonParser.toJson(response));
        return (T)response;
    }

    private <T extends EnOSResponse> T doRequest(EnOSRequest<T> request, Long requestTimestamp) throws EnOSClientException {
        Map textParams = request.getUrlParams();
        String jsonParam = request.getJsonParam();
        if (requestTimestamp == null) {
            requestTimestamp = System.currentTimeMillis();
        }
        textParams.put("requestTimestamp", requestTimestamp.toString());
        String url = this.makeUrl(request.getApiPath(), textParams, jsonParam);
        List transferFileInfos = request.getTransferFiles();
        HashMap<String, List<File>> uploadFiles = new HashMap<String, List<File>>();
        File downloadFile = null;
        int downloadFileCount = 0;
        for (EnOSTransferFileInfo fileInfo : transferFileInfos) {
            if (fileInfo.getTransferType().equals((Object)TransferType.DOWNLOAD)) {
                downloadFile = fileInfo.getFile();
                if (++downloadFileCount <= 1) continue;
                throw new EnOSClientException(EnOSErrorCode.CLIENT_ERROR, "only support single file download");
            }
            if (fileInfo.getFile() == null) continue;
            ArrayList<File> subUploadFiles = (ArrayList<File>)uploadFiles.get(fileInfo.getTransferName());
            if (subUploadFiles == null) {
                subUploadFiles = new ArrayList<File>();
                uploadFiles.put(fileInfo.getTransferName(), subUploadFiles);
            }
            subUploadFiles.add(fileInfo.getFile());
        }
        HttpResponseResult httpResponse = null;
        try {
            EnOSResponse response;
            HttpRequestBase httpRequest = null;
            httpRequest = !request.hasFileUpload() ? WebUtils.getFilledHttpRequest(url, textParams, null, jsonParam, null, "UTF-8", request.getRequestMethod(), this.connectTimeout, this.readTimeout) : WebUtils.getFilledHttpRequestWithFileUpload(url, textParams, null, uploadFiles, "UTF-8", request.getRequestMethod(), this.connectTimeout, this.readTimeout);
            boolean isStream = downloadFile != null;
            httpResponse = WebUtils.getHttpResponseResult(httpRequest, isStream);
            if (downloadFile != null && isStream) {
                EnOSResponse response2 = new EnOSResponse();
                int httpCode = httpResponse.getStatus();
                if (httpCode == 200) {
                    InputStream responseStream = httpResponse.getInputStreamResult();
                    FileUtil.writeFileAsStream((String)downloadFile.getAbsolutePath(), (InputStream)responseStream);
                } else {
                    String strErr = httpResponse.getStringResult();
                    response2.setMsg(strErr);
                }
                response2.setStatus(httpCode);
                EnOSResponse enOSResponse = response2;
                return (T)enOSResponse;
            }
            String strResponse = httpResponse.getStringResult();
            EnOSResponse enOSResponse = response = (EnOSResponse)JacksonUtil.fromJson(strResponse, request.getResponseType());
            return (T)enOSResponse;
        }
        catch (IOException e) {
            logger.error("Execute Post Request Failed!", (Throwable)e);
            throw new EnOSClientException((Throwable)e);
        }
        finally {
            if (httpResponse != null) {
                httpResponse.releaseIfIsStream();
            }
        }
    }

    private String makeUrl(String apiName, Map<String, String> textParams, String bodyContent) throws EnOSClientException {
        String sign = Sign.sign(this.accessKey, this.secretKey, textParams, bodyContent, this.signMethod.getAlgorithm());
        if (Strings.isNullOrEmpty((String)sign)) {
            throw new EnOSClientException(EnOSErrorCode.APP_SIGN_FAIL);
        }
        StringBuilder url = new StringBuilder(this.serverUrl);
        url.append(apiName);
        url.append("?");
        url.append("accessKey=");
        url.append(this.accessKey);
        url.append("&sign=");
        url.append(sign);
        return url.toString();
    }
}

