/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.enosapi.sdk.util;

import com.envisioniot.enos.enosapi.sdk.util.HttpResponseResult;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.EntityUtils;

public class HttpClientUtils {
    private static PoolingHttpClientConnectionManager cm;
    private static String EMPTY_STR;
    private static String UTF_8;

    private static void init() {
        if (cm == null) {
            cm = new PoolingHttpClientConnectionManager();
            cm.setMaxTotal(2000);
            cm.setDefaultMaxPerRoute(500);
        }
    }

    private static CloseableHttpClient getHttpClient() {
        HttpClientUtils.init();
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResult(HttpRequestBase request) throws IOException {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            httpClient = HttpClientUtils.getHttpClient();
            response = httpClient.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                String result = EntityUtils.toString((HttpEntity)entity);
                response.close();
                String string = result;
                return string;
            }
            String string = EMPTY_STR;
            return string;
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (httpClient != null) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getInputStreamResult(HttpRequestBase request) throws IOException {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            httpClient = HttpClientUtils.getHttpClient();
            response = httpClient.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            InputStream inputStream = entity.getContent();
            return inputStream;
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (httpClient != null) {
                // empty if block
            }
        }
    }

    public static HttpResponseResult getHttpResponseResult(HttpRequestBase request) throws IOException {
        return HttpClientUtils.getHttpResponseResult(request, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponseResult getHttpResponseResult(HttpRequestBase request, boolean isStream) throws IOException {
        HttpResponseResult httpResponseResult;
        block7: {
            CloseableHttpClient httpClient = null;
            CloseableHttpResponse response = null;
            HttpEntity entity = null;
            try {
                HttpResponseResult httpResponseResult2;
                httpClient = HttpClientUtils.getHttpClient();
                response = httpClient.execute((HttpUriRequest)request);
                int status = response.getStatusLine().getStatusCode();
                entity = response.getEntity();
                httpResponseResult = httpResponseResult2 = new HttpResponseResult(status, entity, isStream, response);
                if (isStream) break block7;
            }
            catch (Throwable throwable) {
                if (!isStream) {
                    EntityUtils.consume(entity);
                    if (response != null) {
                        response.close();
                    }
                    if (httpClient != null) {
                        // empty if block
                    }
                }
                throw throwable;
            }
            EntityUtils.consume((HttpEntity)entity);
            if (response != null) {
                response.close();
            }
            if (httpClient != null) {
                // empty if block
            }
        }
        return httpResponseResult;
    }

    public static Charset getCharset(HttpEntity entity) {
        Charset charset = null;
        ContentType contentType = ContentType.get((HttpEntity)entity);
        if (contentType != null) {
            charset = contentType.getCharset();
        }
        if (charset == null) {
            charset = HTTP.DEF_CONTENT_CHARSET;
        }
        return charset;
    }

    static {
        EMPTY_STR = "";
        UTF_8 = "UTF-8";
    }
}

