/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.enosapi.sdk.util;

import com.envisioniot.enos.enosapi.common.util.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;

public class HttpResponseResult {
    private int status;
    private boolean isStream;
    private String strResponse;
    private InputStream inputStream;
    CloseableHttpResponse httpResponse = null;
    HttpEntity entity = null;

    public HttpResponseResult(int status, HttpEntity entity, boolean isStream) throws IOException {
        this.status = status;
        this.isStream = isStream;
        if (isStream) {
            this.inputStream = entity.getContent();
        } else {
            this.strResponse = EntityUtils.toString((HttpEntity)entity);
        }
    }

    public HttpResponseResult(int status, HttpEntity entity, boolean isStream, CloseableHttpResponse httpResponse) throws IOException {
        this(status, entity, isStream);
        if (isStream) {
            this.httpResponse = httpResponse;
            this.entity = entity;
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public InputStream getInputStreamResult() {
        if (this.isStream) {
            return this.inputStream;
        }
        return null;
    }

    public String getStringResult() {
        if (!this.isStream) {
            return this.strResponse;
        }
        try {
            this.strResponse = StreamUtil.inputStreamToString((InputStream)this.inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.strResponse;
    }

    public void releaseIfIsStream() {
        if (this.isStream) {
            try {
                EntityUtils.consume((HttpEntity)this.entity);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.httpResponse != null) {
                try {
                    this.httpResponse.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

