/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.enosapi.sdk.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonUtil {
    private static Logger logger = LoggerFactory.getLogger(JacksonUtil.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private JacksonUtil() {
    }

    public static String toJson(Object obj) {
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (Exception e) {
            logger.error("toJson(Object)", (Throwable)e);
            return null;
        }
    }

    public static <T> T fromJson(String json, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, valueType);
        }
        catch (Exception e) {
            logger.error("fromJson(String,Class)", (Throwable)e);
            return null;
        }
    }

    public static <T> T fromJson(String json, Type valueType) {
        try {
            JavaType javaType = OBJECT_MAPPER.getTypeFactory().constructType(valueType);
            return (T)OBJECT_MAPPER.readValue(json, javaType);
        }
        catch (Exception e) {
            logger.error("fromJson(String,Class)", (Throwable)e);
            return null;
        }
    }

    public static <T> T fromJson(String json, TypeReference<T> typeReference) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, typeReference);
        }
        catch (Exception e) {
            logger.error("fromJson(String,TypeReference)", (Throwable)e);
            return null;
        }
    }

    static {
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

