/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.enosapi.sdk.util;

import com.envisioniot.enos.enosapi.common.util.StringUtils;
import com.envisioniot.enos.enosapi.sdk.enums.SignMethods;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sign {
    private static Logger logger = LoggerFactory.getLogger(Sign.class);

    private Sign() {
    }

    private static String convertToHex(byte[] data) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int twoHalfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (twoHalfs++ < 1);
        }
        return buf.toString();
    }

    public static String makeString(String accessKey, String secret, Map<String, String> paramMap, String bodyContent) {
        Object[] keyArray = paramMap.keySet().toArray(new String[0]);
        Arrays.sort(keyArray);
        StringBuilder stringBuilder = new StringBuilder();
        if (accessKey != null) {
            stringBuilder.append(accessKey);
        }
        for (Object key : keyArray) {
            stringBuilder.append((String)key).append(paramMap.get(key));
        }
        if (!StringUtils.isEmpty((String)bodyContent)) {
            stringBuilder.append(bodyContent);
        }
        stringBuilder.append(secret);
        return stringBuilder.toString();
    }

    public static byte[] encryptMD5(byte[] data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest md5 = MessageDigest.getInstance(SignMethods.MD5.getAlgorithm());
            md5.update(data);
            bytes = md5.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        return bytes;
    }

    public static byte[] encryptSHA(byte[] data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest sha = MessageDigest.getInstance(SignMethods.SHA1.getAlgorithm());
            sha.update(data);
            bytes = sha.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        return bytes;
    }

    private static byte[] encryptSHA256(byte[] data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest sha2 = MessageDigest.getInstance(SignMethods.SHA_256.getAlgorithm());
            sha2.update(data);
            bytes = sha2.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        return bytes;
    }

    public static byte[] encryptHMAC(byte[] data, String key) throws IOException {
        byte[] bytes = null;
        try {
            SecretKeySpec sk = new SecretKeySpec(key.getBytes("UTF-8"), SignMethods.HMAC_MD5.getAlgorithm());
            Mac mac = Mac.getInstance(sk.getAlgorithm());
            mac.init(sk);
            bytes = mac.doFinal(data);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
        return bytes;
    }

    public static String sign(String accessKey, String secret, Map<String, String> paramMap, String bodyContent, String type) {
        String sign = null;
        try {
            String codes = Sign.makeString(accessKey, secret, paramMap, bodyContent);
            byte[] bytes = codes.getBytes("UTF-8");
            byte[] encrypt = null;
            SignMethods m = SignMethods.SIGN_METHODS_MAP.get(type);
            switch (m) {
                case SHA1: {
                    encrypt = Sign.encryptSHA(bytes);
                    break;
                }
                case SHA_256: {
                    encrypt = Sign.encryptSHA256(bytes);
                    break;
                }
                case MD5: {
                    encrypt = Sign.encryptMD5(bytes);
                    break;
                }
                case HMAC_MD5: {
                    encrypt = Sign.encryptHMAC(bytes, secret);
                    break;
                }
                default: {
                    encrypt = Sign.encryptSHA256(bytes);
                }
            }
            String hexStr = Sign.convertToHex(encrypt);
            sign = hexStr.toUpperCase();
        }
        catch (UnsupportedEncodingException e) {
            logger.error("UnsupportedEncodingException", (Throwable)e);
            return new String("");
        }
        catch (IOException e) {
            logger.error("IOException", (Throwable)e);
            return new String("");
        }
        return sign;
    }

    public static String sign(String accessKey, String secret, Map<String, String> paramMap, String bodyContent) {
        return Sign.sign(accessKey, secret, paramMap, bodyContent, SignMethods.SHA_256.getAlgorithm());
    }
}

