/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.enosapi.sdk.util;

import com.envisioniot.enos.enosapi.common.exception.EnOSClientException;
import com.envisioniot.enos.enosapi.common.resource.FileStreamInfo;
import com.envisioniot.enos.enosapi.common.util.EnOSErrorCode;
import com.envisioniot.enos.enosapi.common.util.StringUtils;
import com.envisioniot.enos.enosapi.sdk.util.HttpClientUtils;
import com.envisioniot.enos.enosapi.sdk.util.HttpDeleteWithBody;
import com.envisioniot.enos.enosapi.sdk.util.HttpResponseResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebUtils {
    private static Logger logger = LoggerFactory.getLogger(WebUtils.class);
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_GET = "GET";
    public static final String CONTENT_TYPE_MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    public static final String CONTENT_TYPE_APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static String QST_MARK = "?";
    private static String AND_MARK = "&";

    private WebUtils() {
    }

    public static HttpResponseResult doGet(String url, Map<String, String> params, int connectTimeout, int readTimeout) throws IOException, EnOSClientException {
        return WebUtils.doRequest(url, params, null, DEFAULT_CHARSET, METHOD_GET, connectTimeout, readTimeout);
    }

    public static HttpResponseResult doPost(String basicUrl, Map<String, String> urlParams, String bodyContent, int connectTimeout, int readTimeout) throws IOException, EnOSClientException {
        return WebUtils.doRequest(basicUrl, urlParams, bodyContent, DEFAULT_CHARSET, METHOD_POST, connectTimeout, readTimeout);
    }

    public static HttpResponseResult doPut(String basicUrl, Map<String, String> urlParams, String bodyContent, int connectTimeout, int readTimeout) throws IOException, EnOSClientException {
        return WebUtils.doRequest(basicUrl, urlParams, bodyContent, DEFAULT_CHARSET, METHOD_PUT, connectTimeout, readTimeout);
    }

    public static HttpResponseResult doDelete(String basicUrl, Map<String, String> urlParams, String bodyContent, int connectTimeout, int readTimeout) throws IOException, EnOSClientException {
        return WebUtils.doRequest(basicUrl, urlParams, bodyContent, DEFAULT_CHARSET, METHOD_DELETE, connectTimeout, readTimeout);
    }

    public static HttpResponseResult doRequest(String basicUrl, Map<String, String> urlParams, String bodyContent, String charset, String method, int connectTimeout, int readTimeout) throws IOException, EnOSClientException {
        HttpRequestBase httpRequest = WebUtils.getFilledHttpRequest(basicUrl, urlParams, null, bodyContent, null, charset, method, connectTimeout, readTimeout);
        boolean isStream = false;
        return WebUtils.getHttpResponseResult(httpRequest, isStream);
    }

    public static HttpResponseResult getHttpResponseResult(HttpRequestBase request, boolean isStream) throws IOException {
        HttpResponseResult rsp = null;
        try {
            rsp = HttpClientUtils.getHttpResponseResult(request, isStream);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw e;
        }
        return rsp;
    }

    private static URL buildGetUrl(String strUrl, String query) throws IOException {
        URL url = new URL(strUrl);
        if (StringUtils.isEmpty((String)query)) {
            return url;
        }
        strUrl = StringUtils.isEmpty((String)url.getQuery()) ? (strUrl.endsWith(QST_MARK) ? strUrl + query : strUrl + QST_MARK + query) : (strUrl.endsWith(AND_MARK) ? strUrl + query : strUrl + AND_MARK + query);
        return new URL(strUrl);
    }

    public static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String value;
            String name = entry.getKey();
            if (!StringUtils.areNotEmpty((String[])new String[]{name, value = entry.getValue()})) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    private static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (!StringUtils.isEmpty((String)ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isEmpty((String)pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    public static String decode(String value) {
        return WebUtils.decode(value, DEFAULT_CHARSET);
    }

    public static String encode(String value) {
        return WebUtils.encode(value, DEFAULT_CHARSET);
    }

    public static String decode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty((String)value)) {
            try {
                result = URLDecoder.decode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static String encode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty((String)value)) {
            try {
                result = URLEncoder.encode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Deprecated
    private static Map<String, String> getParamsFromUrl(String url) {
        Map<Object, Object> map = null;
        if (url != null && url.indexOf(QST_MARK) != -1) {
            map = WebUtils.splitUrlQuery(url.substring(url.indexOf(QST_MARK) + 1));
        }
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    @Deprecated
    public static Map<String, String> splitUrlQuery(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] pairs = query.split("&");
        if (pairs != null && pairs.length > 0) {
            for (String pair : pairs) {
                String[] param = pair.split("=", 2);
                if (param == null || param.length != 2) continue;
                result.put(param[0], param[1]);
            }
        }
        return result;
    }

    private static void setClientHeader(HttpRequestBase httpClient, String ctype) {
        httpClient.setHeader("Content-Type", ctype);
        httpClient.setHeader("Accept", CONTENT_TYPE_APPLICATION_JSON);
    }

    public static HttpRequestBase getFilledHttpRequestWithFileUpload(String url, Map<String, String> urlParams, Map<String, String> formParams, Map<String, List<File>> uploadFiles, String charset, String requestMethod, int connectTimeout, int readTimeout) throws IOException, EnOSClientException {
        String query = WebUtils.buildQuery(urlParams, charset);
        URL parametricUrl = WebUtils.buildGetUrl(url, query);
        HttpRequestBase httpRequest = WebUtils.getHttpRequest(requestMethod);
        try {
            httpRequest.setURI(parametricUrl.toURI());
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(readTimeout).setConnectTimeout(connectTimeout).build();
            httpRequest.setConfig(requestConfig);
        }
        catch (URISyntaxException e) {
            throw new EnOSClientException((Throwable)e);
        }
        MultipartEntityBuilder mEntityBuilder = MultipartEntityBuilder.create();
        mEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        mEntityBuilder.setCharset(Charset.forName(charset));
        ContentType fileContentType = ContentType.create((String)CONTENT_TYPE_MULTIPART_FORM_DATA, (String)charset);
        if (httpRequest instanceof HttpEntityEnclosingRequestBase) {
            if (uploadFiles != null) {
                for (Map.Entry<String, Object> entry : uploadFiles.entrySet()) {
                    List fileList = (List)entry.getValue();
                    for (File file : fileList) {
                        FileBody fileBody = new FileBody(file, fileContentType);
                        mEntityBuilder.addPart(entry.getKey(), (ContentBody)fileBody);
                    }
                }
            }
            if (formParams != null) {
                for (Map.Entry<String, Object> entry : formParams.entrySet()) {
                    String field = entry.getKey();
                    String value = (String)entry.getValue();
                    StringBody stringBody = new StringBody(value, fileContentType);
                    mEntityBuilder.addPart(field, (ContentBody)stringBody);
                }
            }
            ((HttpEntityEnclosingRequestBase)httpRequest).setEntity(mEntityBuilder.build());
        }
        return httpRequest;
    }

    public static HttpRequestBase getFilledHttpRequest(String url, Map<String, String> urlParams, Map<String, String> formParams, String bodyContent, List<FileStreamInfo> fileStreams, String charset, String requestMethod, int connectTimeout, int readTimeout) throws IOException, EnOSClientException {
        if (bodyContent != null && formParams != null) {
            throw new EnOSClientException(EnOSErrorCode.CLIENT_ERROR, "bodyContent & formParams can not both be not null");
        }
        HttpRequestBase httpRequest = WebUtils.getHttpRequest(requestMethod);
        Object formParamsQuery = null;
        if (fileStreams == null || fileStreams.isEmpty()) {
            String ctype = "application/json;charset=" + charset;
            WebUtils.setClientHeader(httpRequest, ctype);
        }
        String query = WebUtils.buildQuery(urlParams, charset);
        URL parametricUrl = WebUtils.buildGetUrl(url, query);
        try {
            logger.info("Do " + requestMethod + ", url & body: " + parametricUrl.toURI() + " & " + bodyContent);
            httpRequest.setURI(parametricUrl.toURI());
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(readTimeout).setConnectTimeout(connectTimeout).build();
            httpRequest.setConfig(requestConfig);
        }
        catch (URISyntaxException e) {
            throw new EnOSClientException((Throwable)e);
        }
        MultipartEntityBuilder mEntityBuilder = MultipartEntityBuilder.create();
        mEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        mEntityBuilder.setCharset(Charset.forName(charset));
        ContentType fileContentType = ContentType.create((String)CONTENT_TYPE_MULTIPART_FORM_DATA, (String)charset);
        if (httpRequest instanceof HttpEntityEnclosingRequestBase) {
            if (fileStreams != null || formParams != null) {
                String field;
                if (fileStreams != null) {
                    for (FileStreamInfo fileStreamInfo : fileStreams) {
                        field = fileStreamInfo.getFieldName();
                        String fileName = fileStreamInfo.getOriginalFileName();
                        InputStream fileContent = fileStreamInfo.getContent();
                        String contentType = fileStreamInfo.getContentType();
                        InputStreamBody streamBody = new InputStreamBody(fileContent, fileContentType, fileName);
                        mEntityBuilder.addPart(field, (ContentBody)streamBody);
                    }
                }
                if (formParams != null) {
                    for (Map.Entry entry : formParams.entrySet()) {
                        field = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        StringBody stringBody = new StringBody(value, fileContentType);
                        mEntityBuilder.addPart(field, (ContentBody)stringBody);
                    }
                }
                ((HttpEntityEnclosingRequestBase)httpRequest).setEntity(mEntityBuilder.build());
            } else if (bodyContent != null) {
                ((HttpEntityEnclosingRequestBase)httpRequest).setEntity((HttpEntity)new StringEntity(bodyContent, charset));
            }
        }
        return httpRequest;
    }

    public static HttpRequestBase getHttpRequest(String requestMethod) {
        Object httpRequest;
        switch (requestMethod) {
            case "PUT": {
                httpRequest = new HttpPut();
                break;
            }
            case "DELETE": {
                httpRequest = new HttpDeleteWithBody();
                break;
            }
            case "GET": {
                httpRequest = new HttpGet();
                break;
            }
            default: {
                httpRequest = new HttpPost();
            }
        }
        return httpRequest;
    }
}

