package com.eniot.data.query;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

/**
 * @author jinghui.zhao
 */
public interface EniotConnect extends Connection {

    /**
     * execQuerySql
     * @param statement statement
     * @param sql sql
     * @throws SQLException SQLException
     * @return ResultSet
     */
    ResultSet execQuerySql(Statement statement, String sql) throws SQLException;

    /**
     * execQuerySql
     * @param sql sql
     * @return ResultSet
     * @throws SQLException SQLException
     */
    ResultSet execQuerySql(String sql) throws SQLException;

    /**
     * showSchemas
     * @return ResultSet
     * @throws SQLException SQLException
     */
    ResultSet showSchemas() throws SQLException;

    /**
     * showCatalogs
     * @return ResultSet
     * @throws SQLException SQLException
     */
    ResultSet showCatalogs() throws SQLException;

    /**
     * getTableTypes
     * @return ResultSet
     * @throws SQLException SQLException
     */
    ResultSet getTableTypes() throws SQLException;

    /**
     * getURL
     * @return url
     */
    String getURL();

    /**
     * getUser
     * @return user
     */
    String getUser();

    /**
     * getServerVersion
     * @return serverVersion
     */
    String getServerVersion();

    /**
     * getPrivateStatement
     * @return Statement
     * @throws SQLException SQLException
     */
    Statement getPrivateStatement() throws SQLException;

}
