package com.eniot.data.query.entity;

/**
 * @author jinghui.zhao
 */
public enum SupportedDataSoureTypeEnum {

    /**
     * mysql
     */
    MYSQL("MYSQL"),

    /**
     * enos hive
     */
    HIVEENOS("HIVE(EnOS)");

    private String name;

    SupportedDataSoureTypeEnum(String name){
        this.name = name;
    }

    public String getName(){
        return this.name;
    }

    public static SupportedDataSoureTypeEnum getSupportedDataSoureType(String name){
        for (SupportedDataSoureTypeEnum entity : values()){
            if (entity.getName().equals(name)){
                return entity;
            }
        }
        return null;
    }
}
