package com.eniot.data.query.util;

import com.eniot.data.query.exception.SqlError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.MessageDigest;
import java.sql.SQLException;

/**
 * @author jinghui.zhao
 */
public class Sha256Util {

    private static final Logger log = LoggerFactory.getLogger(Sha256Util.class);

    /**
     * 利用java原生的类实现SHA256加密
     *
     * @param str 加密后的报文
     * @return String
     * @throws SQLException SQLException
     */
    public static String getSHA256(String str) throws SQLException {
        MessageDigest messageDigest;
        String encodestr = "";
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes("UTF-8"));
            encodestr = byte2Hex(messageDigest.digest());
        } catch (Exception e) {
            log.error("Sha256Util getSHA256 Exception", e);
            throw SqlError.createSQLException(String.format("SHA256 encode failed, msg = %s.", e.getMessage()),
                    SqlError.SQL_STATE_SHA256_FAILED);

        }
        return encodestr;
    }

    /**
     * 将byte转为16进制
     *
     * @param bytes bytes
     * @return String
     */
    private static String byte2Hex(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder();
        String temp = null;
        for (byte aByte : bytes) {
            temp = Integer.toHexString(aByte & 0xFF);
            if (temp.length() == 1) {
                // 1得到一位的进行补0操作
                stringBuilder.append("0");
            }
            stringBuilder.append(temp);
        }
        return stringBuilder.toString();
    }
}
