/*
 * Decompiled with CFR 0.152.
 */
package com.eniot.data.query;

import com.eniot.data.query.exception.SqlError;
import com.eniot.data.query.impl.ConnectionImpl;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Driver
implements java.sql.Driver {
    private static final Logger log = LoggerFactory.getLogger(Driver.class);
    private static final String URL_PREFIX = "jdbc:datafederation://";
    public static final String PLATFORM = Driver.getPlatform();
    public static final String OS = Driver.getOSName();
    public static final String LICENSE = "@DATA_FEDERATION_LICENSE_TYPE@";
    public static final String RUNTIME_VENDOR = System.getProperty("java.vendor");
    public static final String RUNTIME_VERSION = System.getProperty("java.version");
    public static final String VERSION = "@DATA_FEDERATION_VERSION@";
    public static final String NAME = "@DATA_FEDERATION_DISPLAY_PROD_NAME@";
    public static final String SERVCER_NAME_TO_CONNECT = "data-query-proxy";
    public static final String ORGID_PROPERTY_KEY = "orgId";
    private static final String CHID_PROPERTY_KEY = "chId";
    public static final String SOURCE_PROPERTY_KEY = "source";
    public static final boolean DEBUG = false;
    private static final String HOST_PROPERTY_KEY = "HOST";
    public static final String USER_PROPERTY_KEY = "user";
    public static final String USE_CONFIG_PROPERTY_KEY = "useConfigs";

    public static boolean load() {
        return true;
    }

    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static String getPlatform() {
        return System.getProperty("os.arch");
    }

    public static int getMajorVersionInternal() {
        return Driver.safeIntParse("@ENIOT_EDP_CJ_MAJOR_VERSION@");
    }

    public static int getMinorVersionInternal() {
        return Driver.safeIntParse("@ENIOT_EDP_CJ_MINOR_VERSION@");
    }

    public static int safeIntParse(String intAsString) {
        try {
            return Integer.parseInt(intAsString);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw SqlError.createSQLException("url is null!", "08001");
        }
        return url.startsWith(URL_PREFIX);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        Properties props = null;
        props = this.parseURL(url, info);
        if (props == null) {
            return null;
        }
        if (!props.containsKey(HOST_PROPERTY_KEY)) {
            throw SqlError.createSQLException("url is invalid!", "08001");
        }
        if (!props.containsKey(USER_PROPERTY_KEY)) {
            throw SqlError.createSQLException("user is required to establish a connection!", "08001");
        }
        String psKeyName = "password";
        if (!props.containsKey(psKeyName)) {
            throw SqlError.createSQLException("password is required to establish a connection!", "08001");
        }
        if (!props.containsKey(ORGID_PROPERTY_KEY)) {
            throw SqlError.createSQLException("orgId is required to establish a connection!", "08001");
        }
        String channelPre = "ch-";
        if (!props.containsKey(CHID_PROPERTY_KEY) || !props.getProperty(CHID_PROPERTY_KEY).startsWith(channelPre)) {
            throw SqlError.createSQLException("channelId is required to establish a connection!", "08001");
        }
        try {
            return ConnectionImpl.getInstance(this.host(props), props, this.database(props));
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (Exception ex) {
            log.error("NonRegisteringDriver.connect Exception", ex);
            SQLException sqlEx = SqlError.createSQLException("NonRegisteringDriver.connect Exception" + ex.toString(), "08001");
            sqlEx.initCause(ex);
            throw sqlEx;
        }
    }

    public Properties parseURL(String url, Properties defaults) throws SQLException {
        Properties urlProps;
        Properties properties = urlProps = defaults != null ? defaults : new Properties();
        if (url == null) {
            return null;
        }
        if (!StringUtils.startsWithIgnoreCase(url, URL_PREFIX)) {
            return null;
        }
        int beginningOfSlashes = url.indexOf("//");
        int index = url.indexOf("?");
        if (index == -1) {
            index = url.length() - 1;
        }
        String paramString = url.substring(index + 1);
        url = url.substring(0, index);
        StringTokenizer queryParams = new StringTokenizer(paramString, "&");
        while (queryParams.hasMoreTokens()) {
            String parameterValuePair = queryParams.nextToken();
            int indexOfEquals = StringUtils.indexOfIgnoreCase(parameterValuePair, "=", 0);
            String parameter = null;
            String value = null;
            if (indexOfEquals != -1) {
                parameter = parameterValuePair.substring(0, indexOfEquals);
                if (indexOfEquals + 1 < parameterValuePair.length()) {
                    value = parameterValuePair.substring(indexOfEquals + 1);
                }
            }
            if (!StringUtils.isNotBlank(value) || !StringUtils.isNotBlank(parameter)) continue;
            urlProps.setProperty(parameter, value);
        }
        url = url.substring(beginningOfSlashes + 2);
        urlProps.setProperty(HOST_PROPERTY_KEY, url);
        String chId = url.substring(url.lastIndexOf(47) + 1);
        urlProps.setProperty(CHID_PROPERTY_KEY, chId);
        return urlProps;
    }

    public String database(Properties props) {
        return props.getProperty(CHID_PROPERTY_KEY);
    }

    @Override
    public int getMajorVersion() {
        return Driver.getMajorVersionInternal();
    }

    @Override
    public int getMinorVersion() {
        return Driver.getMinorVersionInternal();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        if (url != null && url.startsWith(URL_PREFIX)) {
            info = this.parseURL(url, info);
        }
        DriverPropertyInfo[] ret = new DriverPropertyInfo[4];
        DriverPropertyInfo hostProp = new DriverPropertyInfo(HOST_PROPERTY_KEY, info.getProperty(HOST_PROPERTY_KEY));
        hostProp.required = true;
        hostProp.description = "url";
        DriverPropertyInfo dbProp = new DriverPropertyInfo(CHID_PROPERTY_KEY, info.getProperty(CHID_PROPERTY_KEY));
        dbProp.required = true;
        dbProp.description = "chId name";
        DriverPropertyInfo userProp = new DriverPropertyInfo(USER_PROPERTY_KEY, info.getProperty(USER_PROPERTY_KEY));
        userProp.required = true;
        userProp.description = USER_PROPERTY_KEY;
        DriverPropertyInfo passwordProp = new DriverPropertyInfo("password", info.getProperty("password"));
        userProp.required = true;
        userProp.description = "password";
        ret[0] = hostProp;
        ret[1] = dbProp;
        ret[2] = userProp;
        ret[3] = passwordProp;
        return ret;
    }

    public String host(Properties props) {
        return props.getProperty(HOST_PROPERTY_KEY, "localhost");
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    public String property(String name, Properties props) {
        return props.getProperty(name);
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (Error | SQLException e) {
            log.error("Error in registering data-query-proxy Driver driver {}: {}", (Object)Driver.class, (Object)e);
        }
    }
}

