/*
 * Decompiled with CFR 0.152.
 */
package com.eniot.data.query.impl;

import com.eniot.data.query.EniotConnect;
import com.eniot.data.query.entity.QueryResponse;
import com.eniot.data.query.exception.SqlError;
import com.eniot.data.query.impl.DatabaseMetaDataImpl;
import com.eniot.data.query.impl.PreparedStatementImpl;
import com.eniot.data.query.impl.RestClient;
import com.eniot.data.query.impl.ResultSetImpl;
import com.eniot.data.query.impl.StatementImpl;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionImpl
implements EniotConnect {
    private static final Logger log = LoggerFactory.getLogger(ConnectionImpl.class);
    private long connectionCreationTimeMillis = 0L;
    private long connectionId;
    private boolean readOnly = true;
    private boolean isClosed = true;
    private DatabaseMetaData dbmd = null;
    private String host = null;
    private String chId = null;
    private String user = null;
    private String source = null;
    private RestClient restClient;
    private static final int DEFAULT_RESULT_SET_TYPE = 1003;
    private static final int DEFAULT_RESULT_SET_CONCURRENCY = 1007;
    private String serverVersion = "0.0.1";
    private volatile Statement statement = null;
    private volatile QueryResponse response = null;
    private final CopyOnWriteArrayList<Statement> openStatements = new CopyOnWriteArrayList();
    private boolean transactionsSupported = false;
    private boolean dbEscapeNeeded = false;
    private static Map<String, Integer> mapTransIsolationNameToValue = null;
    private Properties clientInfo = null;

    public static Connection getInstance(String hostToConnectTo, Properties info, String chIdToConnectTo) throws SQLException {
        return new ConnectionImpl(hostToConnectTo, info, chIdToConnectTo);
    }

    public ConnectionImpl(String hostToConnectTo, Properties info, String chIdToConnectTo) throws SQLException {
        log.info("Connect server start.");
        this.connectionCreationTimeMillis = System.currentTimeMillis();
        this.host = hostToConnectTo;
        this.chId = chIdToConnectTo;
        this.user = info.getProperty("user");
        this.source = info.getProperty("source");
        this.dbEscapeNeeded = Boolean.valueOf(info.getProperty("dbEscapeNeeded", "false"));
        this.restClient = RestClient.getRestClient(this.host, this.chId, info);
        this.isClosed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkClosed() throws SQLException {
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (this.isClosed) {
                log.warn("The connection has closed!");
                throw SqlError.createSQLException("No operations allowed after connection closed.", "08003");
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        log.info("ConnectionImpl.createStatement, resultSetType:{}, resultSetConcurrency:{}", (Object)resultSetType, (Object)resultSetConcurrency);
        this.checkClosed();
        if (resultSetType != 1003 && resultSetType != 1004) {
            throw SqlError.createSQLException("TYPE_FORWARD_ONLY or TYPE_SCROLL_INSENSITIVE is only supported resultSetType level", "S1009");
        }
        if (resultSetConcurrency != 1007) {
            throw SqlError.createSQLException("CONCUR_READ_ONLY is only supported resultSetConcurrency level", "S1009");
        }
        return new StatementImpl(this, resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        log.info("ConnectionImpl.createStatement, resultSetType:{}, resultSetConcurrency:{}, resultSetHoldability:{}", resultSetType, resultSetConcurrency, resultSetHoldability);
        if (resultSetHoldability != 1) {
            throw SqlError.createSQLException("HOLD_CUSRORS_OVER_COMMIT is only supported holdability level", "S1009");
        }
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        log.info("ConnectionImpl.prepareStatement, sql:{}, resultSetType:{}, resultSetConcurrency:{}.", sql, resultSetType, resultSetConcurrency);
        this.checkClosed();
        if (resultSetType != 1003 && resultSetType != 1004) {
            throw SqlError.createSQLException("TYPE_FORWARD_ONLY or TYPE_SCROLL_INSENSITIVE is only supported resultSetType level", "S1009");
        }
        if (resultSetConcurrency != 1007) {
            throw SqlError.createSQLException("CONCUR_READ_ONLY is only supported resultSetConcurrency level", "S1009");
        }
        return new PreparedStatementImpl(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetHoldability != 1) {
            throw SqlError.createSQLException("HOLD_CUSRORS_OVER_COMMIT is only supported holdability level", "S1009");
        }
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        log.info("ConnectionImpl.prepareStatement, sql:{}, autoGeneratedKeys:{}.", (Object)sql, (Object)autoGeneratedKeys);
        throw SqlError.createSQLFeatureNotSupportedException("prepareStatement");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        log.info("ConnectionImpl.prepareStatement, sql:{}, columnIndexes:{}.", (Object)sql, (Object)columnIndexes);
        throw SqlError.createSQLFeatureNotSupportedException("prepareStatement");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        log.info("ConnectionImpl.prepareStatement, sql:{}, columnNames:{}.", (Object)sql, (Object)columnNames);
        throw SqlError.createSQLFeatureNotSupportedException("prepareStatement");
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        log.info("ConnectionImpl.prepareCall, sql:{}.", (Object)sql);
        throw SqlError.createSQLFeatureNotSupportedException("prepareCall");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        if (StringUtils.isNotBlank(sql)) {
            return sql.replace("\"", "`").replaceAll("[\r\n]", " ");
        }
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public void commit() throws SQLException {
        log.info("ConnectionImpl.commit");
    }

    @Override
    public void rollback() throws SQLException {
        log.info("ConnectionImpl.rollback");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.isClosed = true;
            this.restClient = null;
            this.statement = null;
            this.response = null;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getMetaData(true);
    }

    private DatabaseMetaData getMetaData(boolean checkClosed) throws SQLException {
        if (checkClosed) {
            this.checkClosed();
        }
        return DatabaseMetaDataImpl.getInstance(this, this.chId);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return true;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.chId;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        log.info("ConnectionImpl.setTransactionIsolation, level:{}.", (Object)level);
        if (0 != level) {
            throw SqlError.createSQLException("Not support transaction isolation level:" + level, "S1009");
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        log.info("ConnectionImpl.prepareCall");
        throw SqlError.createSQLFeatureNotSupportedException("prepareCall");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        log.info("ConnectionImpl.getTypeMap");
        return new HashMap(0);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("setTypeMap");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        if (1 != holdability) {
            throw SqlError.createSQLException("HOLD_CUSRORS_OVER_COMMIT is only supported holdability level", "S1009");
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("setSavepoint");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("setSavepoint");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("releaseSavepoint");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        log.info("ConnectionImpl.prepareCall");
        throw SqlError.createSQLFeatureNotSupportedException("prepareCall");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("createClob");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("createBlob");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("createNClob");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("createSQLXML");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return !this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        log.info("ConnectionImpl.setClientInfo");
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (this.clientInfo == null) {
                this.clientInfo = new Properties();
            }
            this.clientInfo.setProperty(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        log.info("ConnectionImpl.setClientInfo");
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (this.clientInfo == null) {
                this.clientInfo = new Properties();
            }
            this.clientInfo.putAll((Map<?, ?>)properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClientInfo(String name) throws SQLException {
        log.info("ConnectionImpl.getClientInfo");
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (this.clientInfo != null) {
                return this.clientInfo.getProperty(name);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getClientInfo() throws SQLException {
        log.info("ConnectionImpl.getClientInfo");
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            return this.clientInfo;
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        log.info("ConnectionImpl.createArrayOf");
        throw SqlError.createSQLFeatureNotSupportedException("createArrayOf");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        log.info("ConnectionImpl.createStruct");
        throw SqlError.createSQLFeatureNotSupportedException("createStruct");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        return this.chId;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        log.info("ConnectionImpl.setNetworkTimeout");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 300000;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        log.info("ConnectionImpl.unwrap");
        throw SqlError.createSQLFeatureNotSupportedException("unwrap");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        log.info("ConnectionImpl.isWrapperFor");
        return false;
    }

    @Override
    public ResultSet execQuerySql(Statement statement, String sql) throws SQLException {
        this.checkClosed();
        QueryResponse response = this.restClient.execQuery(sql);
        return new ResultSetImpl(this, statement, response);
    }

    @Override
    public ResultSet execQuerySql(String sql) throws SQLException {
        this.checkClosed();
        if (null == this.statement) {
            this.statement = this.createStatement();
        }
        QueryResponse response = this.restClient.execQuery(sql);
        return new ResultSetImpl(this, this.statement, response);
    }

    @Override
    public ResultSet showSchemas() throws SQLException {
        this.checkClosed();
        if (null == this.statement) {
            this.statement = this.createStatement();
        }
        if (null == this.response) {
            String sql = "show schemas";
            this.response = this.restClient.execQuery(sql);
            String originSchemaKey = "SCHEMA_NAME";
            String finalSchemaKey = "TABLE_SCHEM";
            String catalogKey = "TABLE_CATALOG";
            ArrayList<String> newColumns = new ArrayList<String>(2);
            newColumns.add(finalSchemaKey);
            newColumns.add(catalogKey);
            ArrayList<Map<String, Object>> newRows = new ArrayList<Map<String, Object>>(this.response.getRows().size());
            for (Map<String, Object> item : this.response.getRows()) {
                String[] schemaTableName;
                String schemaName;
                HashMap<String, String> subRow = new HashMap<String, String>(2);
                subRow.put(catalogKey, this.chId);
                Object schemaNameObject = item.get(originSchemaKey);
                String string = schemaName = schemaNameObject == null ? "" : schemaNameObject.toString();
                if (this.source != null) {
                    subRow.put(finalSchemaKey, schemaName);
                    newRows.add(subRow);
                    continue;
                }
                if (StringUtils.isBlank(schemaName) || schemaName.contains("information_schema") || schemaName.contains(".mysql") || schemaName.contains(".performance_schema") || schemaName.contains("sys") || (schemaTableName = schemaName.split("\\.")).length != 2) continue;
                if (this.dbEscapeNeeded) {
                    schemaName = schemaTableName[0] + ".`" + schemaTableName[1] + "`";
                }
                subRow.put(finalSchemaKey, schemaName);
                newRows.add(subRow);
            }
            this.response.setColumns(newColumns);
            this.response.setRows(newRows);
            this.response.getMetadata().add("VARCHAR");
        }
        return new ResultSetImpl(this, this.statement, this.response);
    }

    @Override
    public ResultSet showCatalogs() throws SQLException {
        this.checkClosed();
        QueryResponse queryResponse = new QueryResponse();
        ArrayList<String> columns = new ArrayList<String>(1);
        columns.add("TABLE_CAT");
        ArrayList<String> metadata = new ArrayList<String>(1);
        metadata.add("VARCHAR");
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(1);
        HashMap<String, String> row1 = new HashMap<String, String>(1);
        row1.put("TABLE_CAT", this.chId);
        rows.add(row1);
        queryResponse.setColumns(columns);
        queryResponse.setMetadata(metadata);
        queryResponse.setRows(rows);
        return new ResultSetImpl(this, this.statement, queryResponse);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        this.checkClosed();
        QueryResponse queryResponse = new QueryResponse();
        ArrayList<String> columns = new ArrayList<String>(1);
        columns.add("TABLE_TYPE");
        ArrayList<String> metadata = new ArrayList<String>(1);
        metadata.add("VARCHAR");
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(1);
        HashMap<String, String> row1 = new HashMap<String, String>(1);
        row1.put("TABLE_TYPE", "TABLE");
        rows.add(row1);
        queryResponse.setColumns(columns);
        queryResponse.setMetadata(metadata);
        queryResponse.setRows(rows);
        return new ResultSetImpl(this, this.statement, queryResponse);
    }

    @Override
    public String getURL() {
        return this.host;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public Statement getPrivateStatement() throws SQLException {
        this.checkClosed();
        if (null == this.statement) {
            this.statement = this.createStatement();
        }
        return this.statement;
    }

    static {
        mapTransIsolationNameToValue = new HashMap<String, Integer>(8);
        mapTransIsolationNameToValue.put("READ-UNCOMMITTED", 1);
        mapTransIsolationNameToValue.put("READ-COMMITTED", 2);
        mapTransIsolationNameToValue.put("REPEATABLE-READ", 4);
        mapTransIsolationNameToValue.put("SERIALIZABLE", 8);
    }
}

