/*
 * Decompiled with CFR 0.152.
 */
package com.eniot.data.query.impl;

import com.eniot.data.query.Driver;
import com.eniot.data.query.EniotConnect;
import com.eniot.data.query.entity.DataTypeForSchema;
import com.eniot.data.query.entity.QueryResponse;
import com.eniot.data.query.exception.SqlError;
import com.eniot.data.query.impl.ResultSetImpl;
import com.eniot.data.query.util.JdbcUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javafx.util.Pair;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseMetaDataImpl
implements DatabaseMetaData {
    private static final Logger log = LoggerFactory.getLogger(DatabaseMetaDataImpl.class);
    private EniotConnect connect;
    private String database;
    private static final String PERCENTAGE_SYMBOL = "%";
    private static final String[] SQL92_KEYWORDS = new String[]{"ABSOLUTE", "ACTION", "ADD", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIT", "BIT_LENGTH", "BOTH", "BY", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR", "CHARACTER", "CHARACTER_LENGTH", "CHAR_LENGTH", "CHECK", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTINUE", "CONVERT", "CORRESPONDING", "COUNT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DESCRIPTOR", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOMAIN", "DOUBLE", "DROP", "ELSE", "END", "END-EXEC", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FROM", "FULL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HAVING", "HOUR", "IDENTITY", "IMMEDIATE", "IN", "INDICATOR", "INITIALLY", "INNER", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LANGUAGE", "LAST", "LEADING", "LEFT", "LEVEL", "LIKE", "LOCAL", "LOWER", "MATCH", "MAX", "MIN", "MINUTE", "MODULE", "MONTH", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NOT", "NULL", "NULLIF", "NUMERIC", "OCTET_LENGTH", "OF", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUTER", "OUTPUT", "OVERLAPS", "PAD", "PARTIAL", "POSITION", "PRECISION", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "RESTRICT", "REVOKE", "RIGHT", "ROLLBACK", "ROWS", "SCHEMA", "SCROLL", "SECOND", "SECTION", "SELECT", "SESSION", "SESSION_USER", "SET", "SIZE", "SMALLINT", "SOME", "SPACE", "SQL", "SQLCODE", "SQLERROR", "SQLSTATE", "SUBSTRING", "SUM", "SYSTEM_USER", "TABLE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRIM", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "UPPER", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHEN", "WHENEVER", "WHERE", "WITH", "WORK", "WRITE", "YEAR", "ZONE"};
    private static final String[] SQL2003_KEYWORDS = new String[]{"ABS", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "ARRAY", "AS", "ASENSITIVE", "ASYMMETRIC", "AT", "ATOMIC", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIGINT", "BINARY", "BLOB", "BOOLEAN", "BOTH", "BY", "CALL", "CALLED", "CARDINALITY", "CASCADED", "CASE", "CAST", "CEIL", "CEILING", "CHAR", "CHARACTER", "CHARACTER_LENGTH", "CHAR_LENGTH", "CHECK", "CLOB", "CLOSE", "COALESCE", "COLLATE", "COLLECT", "COLUMN", "COMMIT", "CONDITION", "CONNECT", "CONSTRAINT", "CONVERT", "CORR", "CORRESPONDING", "COUNT", "COVAR_POP", "COVAR_SAMP", "CREATE", "CROSS", "CUBE", "CUME_DIST", "CURRENT", "CURRENT_DATE", "CURRENT_DEFAULT_TRANSFORM_GROUP", "CURRENT_PATH", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_TRANSFORM_GROUP_FOR_TYPE", "CURRENT_USER", "CURSOR", "CYCLE", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DELETE", "DENSE_RANK", "DEREF", "DESCRIBE", "DETERMINISTIC", "DISCONNECT", "DISTINCT", "DOUBLE", "DROP", "DYNAMIC", "EACH", "ELEMENT", "ELSE", "END", "END-EXEC", "ESCAPE", "EVERY", "EXCEPT", "EXEC", "EXECUTE", "EXISTS", "EXP", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FILTER", "FLOAT", "FLOOR", "FOR", "FOREIGN", "FREE", "FROM", "FULL", "FUNCTION", "FUSION", "GET", "GLOBAL", "GRANT", "GROUP", "GROUPING", "HAVING", "HOLD", "HOUR", "IDENTITY", "IN", "INDICATOR", "INNER", "INOUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERSECTION", "INTERVAL", "INTO", "IS", "JOIN", "LANGUAGE", "LARGE", "LATERAL", "LEADING", "LEFT", "LIKE", "LN", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOWER", "MATCH", "MAX", "MEMBER", "MERGE", "METHOD", "MIN", "MINUTE", "MOD", "MODIFIES", "MODULE", "MONTH", "MULTISET", "NATIONAL", "NATURAL", "NCHAR", "NCLOB", "NEW", "NO", "NONE", "NORMALIZE", "NOT", "NULL", "NULLIF", "NUMERIC", "OCTET_LENGTH", "OF", "OLD", "ON", "ONLY", "OPEN", "OR", "ORDER", "OUT", "OUTER", "OVER", "OVERLAPS", "OVERLAY", "PARAMETER", "PARTITION", "PERCENTILE_CONT", "PERCENTILE_DISC", "PERCENT_RANK", "POSITION", "POWER", "PRECISION", "PREPARE", "PRIMARY", "PROCEDURE", "RANGE", "RANK", "READS", "REAL", "RECURSIVE", "REF", "REFERENCES", "REFERENCING", "REGR_AVGX", "REGR_AVGY", "REGR_COUNT", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXX", "REGR_SXY", "REGR_SYY", "RELEASE", "RESULT", "RETURN", "RETURNS", "REVOKE", "RIGHT", "ROLLBACK", "ROLLUP", "ROW", "ROWS", "ROW_NUMBER", "SAVEPOINT", "SCOPE", "SCROLL", "SEARCH", "SECOND", "SELECT", "SENSITIVE", "SESSION_USER", "SET", "SIMILAR", "SMALLINT", "SOME", "SPECIFIC", "SPECIFICTYPE", "SQL", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "SQRT", "START", "STATIC", "STDDEV_POP", "STDDEV_SAMP", "SUBMULTISET", "SUBSTRING", "SUM", "SYMMETRIC", "SYSTEM", "SYSTEM_USER", "TABLE", "TABLESAMPLE", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSLATE", "TRANSLATION", "TREAT", "TRIGGER", "TRIM", "TRUE", "UESCAPE", "UNION", "UNIQUE", "UNKNOWN", "UNNEST", "UPDATE", "UPPER", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARYING", "VAR_POP", "VAR_SAMP", "WHEN", "WHENEVER", "WHERE", "WIDTH_BUCKET", "WINDOW", "WITH", "WITHIN", "WITHOUT", "YEAR"};
    private static volatile String mysqlKeywords = null;

    private DatabaseMetaDataImpl(EniotConnect connect, String database) {
        this.connect = connect;
        this.database = database;
    }

    public static DatabaseMetaData getInstance(EniotConnect connect, String database) {
        return new DatabaseMetaDataImpl(connect, database);
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return this.connect.getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.connect.getUser();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return true;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "EnIOT.DATA-FEDERATION";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.connect.getServerVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        return "@DATA_FEDERATION_DISPLAY_PROD_NAME@";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return "@DATA_FEDERATION_VERSION@";
    }

    @Override
    public int getDriverMajorVersion() {
        return Driver.getMajorVersionInternal();
    }

    @Override
    public int getDriverMinorVersion() {
        return Driver.getMinorVersionInternal();
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "`";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "ABSENT,ANALYZE,CALL,COMPUTE,CONDITIONAL,DATABASES,DEFINE,ENCODING,ERROR,ESTIMATE,EXPLAIN,FILES,FORMAT,GROUPING,IF,JAR,JSON_ARRAY,JSON_ARRAYAGG,JSON_EXISTS,JSON_OBJECT,JSON_OBJECTAGG,JSON_QUERY,JSON_VALUE,LATERAL,LIMIT,LOAD,MATCH_RECOGNIZE,MERGE,METADATA,MINUS,NEW,OFFSET,OVER,PARTITION,PASSING,PATTERN,PROPERTIES,RANGE,REFRESH,RETURNING,ROLLUP,ROW,SAMPLE,SCALAR,SCHEMAS,SKIP,STATISTICS,STREAM,TABLES,TABLESAMPLE,UNCONDITIONAL,UNNEST,USE,UTF16,UTF32,UTF8,WINDOW";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MOD,PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "CONCAT,INSERT,LCASE,LENGTH,LOCATE,LTRIM,REPLACE,RTRIM,SUBSTRING,UCASE";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "CONVERT,DATABASE,IFNULL,USER";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "CURDATE,CURTIME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,MINUTE,MONTH,NOW,QUARTER,SECOND,TIMESTAMPADD,TIMESTAMPDIFF,WEEK,YEAR";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "procedure";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "catalog";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 128;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 1;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 1;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 1024;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 1024;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 100;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 1024;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 1024;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 1024;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 100;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 1024;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 1024;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 0;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return true;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        log.info("DatabaseMetaDataImpl.dataDefinitionIgnoredInTransactions");
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        log.info("DatabaseMetaDataImpl.getProcedures, catalog:{}, schemaPattern:{}, procedureNamePattern:{}", catalog, schemaPattern, procedureNamePattern);
        QueryResponse queryResponse = new QueryResponse();
        ArrayList<String> columns = new ArrayList<String>(8);
        columns.add("PROCEDURE_CAT");
        columns.add("PROCEDURE_SCHEM");
        columns.add("PROCEDURE_NAME");
        columns.add("PROCEDURE_TYPE");
        columns.add("SPECIFIC_NAME");
        ArrayList<String> metadata = new ArrayList<String>(8);
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("INT");
        metadata.add("VARCHAR");
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(0);
        queryResponse.setColumns(columns);
        queryResponse.setMetadata(metadata);
        queryResponse.setRows(rows);
        return new ResultSetImpl(this.connect, this.connect.getPrivateStatement(), queryResponse);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        log.info("DatabaseMetaDataImpl.getProcedureColumns, catalog:{}, schemaPattern:{}, procedureNamePattern:{}, columnNamePattern:{}", catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        QueryResponse queryResponse = new QueryResponse();
        ArrayList<String> columns = new ArrayList<String>(4);
        columns.add("PROCEDURE_CAT");
        columns.add("PROCEDURE_SCHEM");
        columns.add("PROCEDURE_NAME");
        columns.add("COLUMN_NAME");
        ArrayList<String> metadata = new ArrayList<String>(4);
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(0);
        queryResponse.setColumns(columns);
        queryResponse.setMetadata(metadata);
        queryResponse.setRows(rows);
        return new ResultSetImpl(this.connect, this.connect.getPrivateStatement(), queryResponse);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        log.info("DatabaseMetaDataImpl.getTables, catalog:{}, schemaPattern:{}, tableNamePattern:{}, types:{}", catalog, schemaPattern, tableNamePattern, types);
        QueryResponse queryResponse = new QueryResponse();
        ArrayList<String> columns = new ArrayList<String>(4);
        columns.add("TABLE_CAT");
        columns.add("TABLE_SCHEM");
        columns.add("TABLE_NAME");
        columns.add("TABLE_TYPE");
        ArrayList<String> metadata = new ArrayList<String>(4);
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(16);
        ResultSet schemas = this.getSchemas();
        while (schemas.next()) {
            String schemaName = schemas.getString(1);
            if (StringUtils.isNotBlank(schemaPattern) && !PERCENTAGE_SYMBOL.equals(schemaPattern) && !schemaPattern.equals(schemaName)) continue;
            String tmpSchemaName = schemaName.endsWith("`") ? schemaName : "`" + schemaName + "`";
            ResultSet tables = this.connect.execQuerySql("show tables from " + tmpSchemaName);
            String tableNameKey = "TABLE_NAME";
            while (tables.next()) {
                String tableName = tables.getString(tableNameKey);
                if (StringUtils.isNotBlank(tableNamePattern) && !PERCENTAGE_SYMBOL.equals(tableNamePattern) && !tableNamePattern.equals(tableName)) continue;
                HashMap<String, String> row = new HashMap<String, String>(4);
                row.put("TABLE_CAT", catalog);
                row.put("TABLE_SCHEM", schemaName);
                row.put("TABLE_NAME", tableName);
                row.put("TABLE_TYPE", "TABLE");
                rows.add(row);
            }
        }
        queryResponse.setColumns(columns);
        queryResponse.setMetadata(metadata);
        queryResponse.setRows(rows);
        return new ResultSetImpl(this.connect, this.connect.getPrivateStatement(), queryResponse);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.connect.showSchemas();
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        log.info("DatabaseMetaDataImpl.getCatalogs");
        return this.connect.showCatalogs();
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        log.info("DatabaseMetaDataImpl.getTableTypes");
        return this.connect.getTableTypes();
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        log.info("DatabaseMetaDataImpl.getColumns, catalog:{}, schemaPattern:{}, tableNamePattern:{}, columnNamePattern:{}", catalog, schemaPattern, tableNamePattern, columnNamePattern);
        QueryResponse queryResponse = new QueryResponse();
        ArrayList<String> columns = new ArrayList<String>(19);
        columns.add("TABLE_CAT");
        columns.add("TABLE_SCHEM");
        columns.add("TABLE_NAME");
        columns.add("COLUMN_NAME");
        columns.add("DATA_TYPE");
        columns.add("TYPE_NAME");
        columns.add("COLUMN_SIZE");
        columns.add("BUFFER_LENGTH");
        columns.add("DECIMAL_DIGITS");
        columns.add("NUM_PREC_RADIX");
        columns.add("NULLABLE");
        columns.add("REMARKS");
        columns.add("COLUMN_DEF");
        columns.add("SQL_DATA_TYPE");
        columns.add("SQL_DATETIME_SUB");
        columns.add("CHAR_OCTET_LENGTH");
        columns.add("ORDINAL_POSITION");
        columns.add("IS_NULLABLE");
        columns.add("IS_AUTOINCREMENT");
        ArrayList<String> metadata = new ArrayList<String>(19);
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("SMALLINT");
        metadata.add("VARCHAR");
        metadata.add("INT");
        metadata.add("INT");
        metadata.add("INT");
        metadata.add("INT");
        metadata.add("INT");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("INT");
        metadata.add("INT");
        metadata.add("INT");
        metadata.add("INT");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(16);
        ResultSet schemas = this.getSchemas();
        while (schemas.next()) {
            String schemaName = schemas.getString(1);
            if (StringUtils.isNotBlank(schemaPattern) && !PERCENTAGE_SYMBOL.equals(schemaPattern) && !schemaPattern.equals(schemaName)) continue;
            String tmpSchemaName = schemaName.endsWith("`") ? schemaName : "`" + schemaName + "`";
            ResultSet tables = this.connect.execQuerySql("show tables from " + tmpSchemaName);
            String tableNameKey = "TABLE_NAME";
            while (tables.next()) {
                ResultSet columnsInfo;
                String tableName = tables.getString(tableNameKey);
                if (StringUtils.isNotBlank(tableNamePattern) && !PERCENTAGE_SYMBOL.equals(tableNamePattern) && !tableNamePattern.equals(tableName)) continue;
                String descTableSql = "desc " + tmpSchemaName + ".`" + tableName + "`";
                try {
                    columnsInfo = this.connect.execQuerySql(descTableSql);
                }
                catch (Exception e) {
                    log.info(e.getMessage());
                    continue;
                }
                String columnNameKey = "COLUMN_NAME";
                String dataTypeKey = "DATA_TYPE";
                String isNullableKey = "IS_NULLABLE";
                int position = 1;
                while (columnsInfo.next()) {
                    String columnName = columnsInfo.getString(columnNameKey);
                    if (StringUtils.isNotBlank(columnNamePattern) && !PERCENTAGE_SYMBOL.equals(columnNamePattern) && !columnNamePattern.equals(columnName)) continue;
                    HashMap<String, Object> row = new HashMap<String, Object>(19);
                    row.put("TABLE_CAT", catalog);
                    row.put("TABLE_SCHEM", schemaName);
                    row.put("TABLE_NAME", tableName);
                    row.put("COLUMN_NAME", columnName);
                    Pair<Integer, String> pair = this.convertDataType(columnsInfo.getString(dataTypeKey));
                    int dataType = (Integer)pair.getKey();
                    row.put("DATA_TYPE", dataType);
                    row.put("TYPE_NAME", pair.getValue());
                    row.put("COLUMN_SIZE", JdbcUtils.getPrecisionFromTypes(dataType));
                    row.put("BUFFER_LENGTH", 0);
                    row.put("DECIMAL_DIGITS", JdbcUtils.getScaleFromTypes(dataType));
                    row.put("NUM_PREC_RADIX", 10);
                    if ("NO".equals(columnsInfo.getString(isNullableKey))) {
                        row.put("NULLABLE", 0);
                    } else {
                        row.put("NULLABLE", 1);
                    }
                    row.put("REMARKS", "");
                    row.put("COLUMN_DEF", null);
                    row.put("SQL_DATA_TYPE", 0);
                    row.put("SQL_DATETIME_SUB", 0);
                    if (JdbcUtils.isNumberType(dataType)) {
                        row.put("CHAR_OCTET_LENGTH", 0);
                    } else {
                        row.put("CHAR_OCTET_LENGTH", JdbcUtils.getPrecisionFromTypes(dataType));
                    }
                    row.put("ORDINAL_POSITION", position++);
                    row.put("IS_NULLABLE", columnsInfo.getString(isNullableKey));
                    row.put("IS_AUTOINCREMENT", "NO");
                    rows.add(row);
                }
            }
        }
        queryResponse.setColumns(columns);
        queryResponse.setMetadata(metadata);
        queryResponse.setRows(rows);
        return new ResultSetImpl(this.connect, this.connect.getPrivateStatement(), queryResponse);
    }

    private Pair<Integer, String> convertDataType(String type) {
        if (null == type) {
            return new Pair((Object)12, (Object)"VARCHAR");
        }
        if (type.equals(DataTypeForSchema.CHARACTER_VARYING.getType())) {
            return new Pair((Object)12, (Object)"VARCHAR");
        }
        if (type.equals(DataTypeForSchema.BIT.getType())) {
            return new Pair((Object)-7, (Object)"BIT");
        }
        if (type.equals(DataTypeForSchema.BOOLEAN.getType())) {
            return new Pair((Object)16, (Object)"BOOLEAN");
        }
        if (type.equals(DataTypeForSchema.TINYINT.getType())) {
            return new Pair((Object)-6, (Object)"TINYINT");
        }
        if (type.equals(DataTypeForSchema.SMALLINT.getType())) {
            return new Pair((Object)5, (Object)"SMALLINT");
        }
        if (type.equals(DataTypeForSchema.INTEGER.getType())) {
            return new Pair((Object)4, (Object)"INTEGER");
        }
        if (type.equals(DataTypeForSchema.BIGINT.getType())) {
            return new Pair((Object)-5, (Object)"BIGINT");
        }
        if (type.equals(DataTypeForSchema.DOUBLE.getType())) {
            return new Pair((Object)8, (Object)"DOUBLE");
        }
        if (type.equals(DataTypeForSchema.FLOAT.getType()) || type.equals(DataTypeForSchema.REAL.getType())) {
            return new Pair((Object)6, (Object)"FLOAT");
        }
        if (type.equals(DataTypeForSchema.DECIMAL.getType())) {
            return new Pair((Object)3, (Object)"DECIMAL");
        }
        if (type.equals(DataTypeForSchema.DATE.getType())) {
            return new Pair((Object)91, (Object)"DATE");
        }
        if (type.equals(DataTypeForSchema.TIME.getType())) {
            return new Pair((Object)92, (Object)"TIME");
        }
        if (type.equals(DataTypeForSchema.TIMESTAMP.getType())) {
            return new Pair((Object)93, (Object)"TIMESTAMP");
        }
        if (type.equals(DataTypeForSchema.CHARACTER.getType())) {
            return new Pair((Object)1, (Object)"CHAR");
        }
        if (type.equals(DataTypeForSchema.ANY.getType())) {
            return new Pair((Object)-1, (Object)"LONGVARCHAR");
        }
        return new Pair((Object)12, (Object)"VARCHAR");
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        log.info("DatabaseMetaDataImpl.getColumnPrivileges");
        throw SqlError.createSQLFeatureNotSupportedException("getColumnPrivileges");
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        log.info("DatabaseMetaDataImpl.getTablePrivileges");
        throw SqlError.createSQLFeatureNotSupportedException("getTablePrivileges");
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        log.info("DatabaseMetaDataImpl.getBestRowIdentifier");
        throw SqlError.createSQLFeatureNotSupportedException("getBestRowIdentifier");
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        log.info("DatabaseMetaDataImpl.getVersionColumns");
        throw SqlError.createSQLFeatureNotSupportedException("getVersionColumns");
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        log.info("DatabaseMetaDataImpl.getPrimaryKeys");
        QueryResponse queryResponse = new QueryResponse();
        ArrayList<String> columns = new ArrayList<String>(8);
        columns.add("TABLE_CAT");
        columns.add("TABLE_SCHEM");
        columns.add("TABLE_NAME");
        columns.add("COLUMN_NAME");
        columns.add("KEY_SEQ");
        columns.add("PK_NAME");
        ArrayList<String> metadata = new ArrayList<String>(8);
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("SMALLINT");
        metadata.add("VARCHAR");
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(0);
        queryResponse.setColumns(columns);
        queryResponse.setMetadata(metadata);
        queryResponse.setRows(rows);
        return new ResultSetImpl(this.connect, this.connect.getPrivateStatement(), queryResponse);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        log.info("DatabaseMetaDataImpl.getImportedKeys");
        QueryResponse queryResponse = new QueryResponse();
        ArrayList<String> columns = new ArrayList<String>(8);
        columns.add("PKTABLE_CAT");
        columns.add("PKTABLE_SCHEM");
        columns.add("PKTABLE_NAME");
        columns.add("PKCOLUMN_NAME");
        columns.add("FKTABLE_CAT");
        columns.add("FKTABLE_SCHEM");
        columns.add("FKTABLE_NAME");
        columns.add("FKCOLUMN_NAME");
        columns.add("KEY_SEQ");
        columns.add("UPDATE_RULE");
        columns.add("DELETE_RULE");
        ArrayList<String> metadata = new ArrayList<String>(8);
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("SMALLINT");
        metadata.add("SMALLINT");
        metadata.add("SMALLINT");
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(0);
        queryResponse.setColumns(columns);
        queryResponse.setMetadata(metadata);
        queryResponse.setRows(rows);
        return new ResultSetImpl(this.connect, this.connect.getPrivateStatement(), queryResponse);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        log.info("DatabaseMetaDataImpl.getExportedKeys");
        throw SqlError.createSQLFeatureNotSupportedException("getExportedKeys");
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        log.info("DatabaseMetaDataImpl.getCrossReference");
        throw SqlError.createSQLFeatureNotSupportedException("getCrossReference");
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        log.info("DatabaseMetaDataImpl.getTypeInfo");
        throw SqlError.createSQLFeatureNotSupportedException("getTypeInfo");
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        log.info("DatabaseMetaDataImpl.getIndexInfo");
        QueryResponse queryResponse = new QueryResponse();
        ArrayList<String> columns = new ArrayList<String>(8);
        columns.add("TABLE_CAT");
        columns.add("TABLE_SCHEM");
        columns.add("TABLE_NAME");
        columns.add("NON_UNIQUE");
        columns.add("INDEX_QUALIFIER");
        columns.add("INDEX_NAME");
        columns.add("TYPE");
        columns.add("ORDINAL_POSITION");
        columns.add("COLUMN_NAME");
        columns.add("ASC_OR_DESC");
        columns.add("CARDINALITY");
        columns.add("PAGES");
        columns.add("FILTER_CONDITION");
        ArrayList<String> metadata = new ArrayList<String>(8);
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("BOOLEAN");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("SMALLINT");
        metadata.add("SMALLINT");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("BIGINT");
        metadata.add("BIGINT");
        metadata.add("VARCHAR");
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(0);
        queryResponse.setColumns(columns);
        queryResponse.setMetadata(metadata);
        queryResponse.setRows(rows);
        return new ResultSetImpl(this.connect, this.connect.getPrivateStatement(), queryResponse);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        log.info("DatabaseMetaDataImpl.supportsResultSetType");
        return type == 1003 || type == 1004;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        log.info("DatabaseMetaDataImpl.supportsResultSetConcurrency");
        switch (type) {
            case 1004: {
                return concurrency == 1007;
            }
            case 1003: {
                return concurrency == 1007;
            }
            case 1005: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        log.info("DatabaseMetaDataImpl.ownUpdatesAreVisible");
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        log.info("DatabaseMetaDataImpl.ownDeletesAreVisible");
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        log.info("DatabaseMetaDataImpl.ownInsertsAreVisible");
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        log.info("DatabaseMetaDataImpl.othersUpdatesAreVisible");
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        log.info("DatabaseMetaDataImpl.othersDeletesAreVisible");
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        log.info("DatabaseMetaDataImpl.getUDTs, catalog:{}, schemaPattern:{}, typeNamePattern:{}, types:{}", catalog, schemaPattern, typeNamePattern, types);
        QueryResponse queryResponse = new QueryResponse();
        ArrayList<String> columns = new ArrayList<String>(8);
        columns.add("TYPE_CAT");
        columns.add("TYPE_SCHEM");
        columns.add("TYPE_NAME");
        columns.add("CLASS_NAME");
        ArrayList<String> metadata = new ArrayList<String>(8);
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(0);
        queryResponse.setColumns(columns);
        queryResponse.setMetadata(metadata);
        queryResponse.setRows(rows);
        return new ResultSetImpl(this.connect, this.connect.getPrivateStatement(), queryResponse);
    }

    @Override
    public Connection getConnection() throws SQLException {
        log.info("DatabaseMetaDataImpl.getConnection");
        return this.connect;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        log.info("DatabaseMetaDataImpl.supportsSavepoints");
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        log.info("DatabaseMetaDataImpl.supportsNamedParameters");
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        log.info("DatabaseMetaDataImpl.supportsMultipleOpenResults");
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        log.info("DatabaseMetaDataImpl.supportsGetGeneratedKeys");
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        log.info("DatabaseMetaDataImpl.getSuperTypes");
        return null;
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        log.info("DatabaseMetaDataImpl.getSuperTables");
        return null;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        log.info("DatabaseMetaDataImpl.getAttributes");
        return null;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        log.info("DatabaseMetaDataImpl.supportsResultSetHoldability");
        return holdability == 1;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        log.info("DatabaseMetaDataImpl.getResultSetHoldability");
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        log.info("DatabaseMetaDataImpl.getDatabaseMajorVersion");
        return Driver.getMajorVersionInternal();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        log.info("DatabaseMetaDataImpl.getDatabaseMinorVersion");
        return Driver.getMinorVersionInternal();
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        log.info("DatabaseMetaDataImpl.getJDBCMajorVersion");
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        log.info("DatabaseMetaDataImpl.getJDBCMinorVersion");
        return 1;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        log.info("DatabaseMetaDataImpl.getSQLStateType");
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        log.info("DatabaseMetaDataImpl.locatorsUpdateCopy");
        return true;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        log.info("DatabaseMetaDataImpl.supportsStatementPooling");
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        log.info("DatabaseMetaDataImpl.getRowIdLifetime");
        throw SqlError.createSQLFeatureNotSupportedException("getRowIdLifetime");
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        log.info("DatabaseMetaDataImpl.getSchemas, catalog:{}, schemaPattern:{}", (Object)catalog, (Object)schemaPattern);
        ResultSet resultSet = this.getSchemas();
        if (StringUtils.isNotBlank(schemaPattern) && !PERCENTAGE_SYMBOL.equals(schemaPattern)) {
            QueryResponse queryResponse = new QueryResponse();
            ArrayList<String> columns = new ArrayList<String>(2);
            columns.add("TABLE_CATALOG");
            columns.add("TABLE_SCHEM");
            ArrayList<String> metadata = new ArrayList<String>(2);
            metadata.add("VARCHAR");
            metadata.add("VARCHAR");
            ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(2);
            while (resultSet.next()) {
                if (!schemaPattern.equals(resultSet.getString("TABLE_SCHEM"))) continue;
                HashMap<String, String> subRow = new HashMap<String, String>(2);
                subRow.put("TABLE_CATALOG", resultSet.getString("TABLE_CATALOG"));
                subRow.put("TABLE_SCHEM", schemaPattern);
                rows.add(subRow);
            }
            queryResponse.setColumns(columns);
            queryResponse.setMetadata(metadata);
            queryResponse.setRows(rows);
            return new ResultSetImpl(this.connect, this.connect.getPrivateStatement(), queryResponse);
        }
        return resultSet;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        log.info("DatabaseMetaDataImpl.supportsStoredFunctionsUsingCallSyntax");
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        log.info("DatabaseMetaDataImpl.autoCommitFailureClosesAllResultSets");
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        log.info("DatabaseMetaDataImpl.getClientInfoProperties");
        QueryResponse queryResponse = new QueryResponse();
        ArrayList<String> columns = new ArrayList<String>(4);
        columns.add("NAME");
        columns.add("MAX_LEN");
        columns.add("DEFAULT_VALUE");
        columns.add("DESCRIPTION");
        ArrayList<String> metadata = new ArrayList<String>(4);
        metadata.add("VARCHAR");
        metadata.add("INT");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(0);
        queryResponse.setColumns(columns);
        queryResponse.setMetadata(metadata);
        queryResponse.setRows(rows);
        return new ResultSetImpl(this.connect, this.connect.getPrivateStatement(), queryResponse);
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        log.info("DatabaseMetaDataImpl.getFunctions, catalog:{}, schemaPattern:{}, functionNamePattern:{}.", catalog, schemaPattern, functionNamePattern);
        QueryResponse queryResponse = new QueryResponse();
        ArrayList<String> columns = new ArrayList<String>(8);
        columns.add("FUNCTION_CAT");
        columns.add("FUNCTION_SCHEM");
        columns.add("FUNCTION_NAME");
        columns.add("REMARKS");
        columns.add("COLUMN_NAME");
        columns.add("COLUMN_TYPE");
        ArrayList<String> metadata = new ArrayList<String>(8);
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(0);
        queryResponse.setColumns(columns);
        queryResponse.setMetadata(metadata);
        queryResponse.setRows(rows);
        return new ResultSetImpl(this.connect, this.connect.getPrivateStatement(), queryResponse);
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        log.info("DatabaseMetaDataImpl.getFunctionColumns, catalog:{}, schemaPattern:{}, functionNamePattern:{}, columnNamePattern:{}", catalog, schemaPattern, functionNamePattern, columnNamePattern);
        QueryResponse queryResponse = new QueryResponse();
        ArrayList<String> columns = new ArrayList<String>(8);
        columns.add("FUNCTION_CAT");
        columns.add("FUNCTION_SCHEM");
        columns.add("FUNCTION_NAME");
        columns.add("COLUMN_NAME");
        columns.add("COLUMN_TYPE");
        ArrayList<String> metadata = new ArrayList<String>(8);
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        metadata.add("VARCHAR");
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(0);
        queryResponse.setColumns(columns);
        queryResponse.setMetadata(metadata);
        queryResponse.setRows(rows);
        return new ResultSetImpl(this.connect, this.connect.getPrivateStatement(), queryResponse);
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        log.info("DatabaseMetaDataImpl.getPseudoColumns");
        throw SqlError.createSQLFeatureNotSupportedException("insertRow");
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        log.info("DatabaseMetaDataImpl.generatedKeyAlwaysReturned");
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        log.info("DatabaseMetaDataImpl.unwrap");
        throw SqlError.createSQLFeatureNotSupportedException("insertRow");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        log.info("DatabaseMetaDataImpl.isWrapperFor");
        return false;
    }
}

