/*
 * Decompiled with CFR 0.152.
 */
package com.eniot.data.query.impl;

import com.eniot.data.query.exception.SqlError;
import com.eniot.data.query.util.JdbcUtils;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterMetaDataImpl
implements ParameterMetaData {
    private static final Logger log = LoggerFactory.getLogger(ParameterMetaDataImpl.class);
    private boolean[] isNull = null;
    private int[] parameterTypes = null;
    private int parameterCount = 0;

    public ParameterMetaDataImpl(int parameterCount, int[] parameterTypes, boolean[] isNull) {
        this.parameterCount = parameterCount;
        this.parameterTypes = parameterTypes;
        this.isNull = isNull;
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.parameterCount;
    }

    @Override
    public int isNullable(int param) throws SQLException {
        log.info("ParameterMetaDataImpl.isNullable, param:{}", (Object)param);
        return 0;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        this.checkBounds(param);
        int type = this.parameterTypes[param];
        switch (type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        this.checkBounds(param);
        int type = this.parameterTypes[param];
        return JdbcUtils.getPrecisionFromTypes(type);
    }

    @Override
    public int getScale(int param) throws SQLException {
        this.checkBounds(param);
        int type = this.parameterTypes[param];
        return JdbcUtils.getPrecisionFromTypes(type);
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        log.info("ParameterMetaDataImpl.getParameterType, param:{}", (Object)param);
        this.checkBounds(param);
        return this.parameterTypes[param - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBounds(int paramIndex) throws SQLException {
        ParameterMetaDataImpl parameterMetaDataImpl = this;
        synchronized (parameterMetaDataImpl) {
            if (paramIndex < 1) {
                throw SqlError.createSQLException(String.format("Param index out of range, %d < 1.", paramIndex), "S1009");
            }
            if (paramIndex > this.parameterCount) {
                throw SqlError.createSQLException(String.format("Param index out of range, %d > %d.", paramIndex, this.parameterCount), "S1009");
            }
        }
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        int type = this.getParameterType(param);
        return JdbcUtils.getTypeNameFromTypes(type);
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        int type = this.getParameterType(param);
        return JdbcUtils.getClassNameFromTypes(type);
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        return 0;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("unwrap");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

