/*
 * Decompiled with CFR 0.152.
 */
package com.eniot.data.query.impl;

import com.eniot.data.query.EniotConnect;
import com.eniot.data.query.entity.QueryResponse;
import com.eniot.data.query.exception.SqlError;
import com.eniot.data.query.impl.ParameterMetaDataImpl;
import com.eniot.data.query.impl.ResultSetImpl;
import com.eniot.data.query.impl.StatementImpl;
import com.eniot.data.query.util.JdbcUtils;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedStatementImpl
implements PreparedStatement {
    private static final Logger log = LoggerFactory.getLogger(PreparedStatementImpl.class);
    protected volatile EniotConnect connection = null;
    protected int statementId;
    static int statementCounter = 1;
    protected int resultSetConcurrency = 0;
    protected int resultSetType = 0;
    private boolean isClosed = false;
    private volatile ResultSet results = null;
    private int maxFieldSize = Integer.MAX_VALUE;
    private int maxRows = 640000;
    private int fetchDirection = 1000;
    private int fetchSize = 640000;
    private String originalSql = null;
    private boolean[] isNull = null;
    private String[] staticSql = null;
    private String[] parameterValues = null;
    private int[] parameterTypes = null;
    private int parameterCount = 0;
    private int hasSpecifiedParamCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String asSql() throws SQLException {
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            this.checkClosed();
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < this.parameterCount; ++i) {
                buf.append(this.staticSql[i]);
                if (this.parameterValues[i] == null) {
                    buf.append("** NOT SPECIFIED **");
                    continue;
                }
                buf.append(this.parameterValues[i]);
            }
            buf.append(this.staticSql[this.parameterCount]);
            return buf.toString();
        }
    }

    public PreparedStatementImpl(EniotConnect c, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (c == null || c.isClosed()) {
            throw SqlError.createSQLException("No operations allowed after connection closed.", "08003");
        }
        JdbcUtils.checkSql(sql);
        this.connection = c;
        this.statementId = StatementImpl.statementCounter++;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.originalSql = this.connection.nativeSQL(sql);
        this.initializeSql(this.originalSql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSql(String sql) throws SQLException {
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            int i;
            int statementLength = sql.length();
            ArrayList<int[]> endpointList = new ArrayList<int[]>();
            int lastParmEnd = 0;
            for (i = 0; i < statementLength; ++i) {
                char c = sql.charAt(i);
                if (c != '?') continue;
                endpointList.add(new int[]{lastParmEnd, i});
                lastParmEnd = i + 1;
            }
            endpointList.add(new int[]{lastParmEnd, statementLength});
            this.staticSql = new String[endpointList.size()];
            for (i = 0; i < this.staticSql.length; ++i) {
                int[] ep = (int[])endpointList.get(i);
                int begin = ep[0];
                int end = ep[1];
                this.staticSql[i] = sql.substring(begin, end);
            }
            this.parameterCount = this.staticSql.length - 1;
            this.parameterValues = new String[this.parameterCount];
            this.isNull = new boolean[this.parameterCount];
            this.parameterTypes = new int[this.parameterCount];
            this.clearParameters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkClosed() throws SQLException {
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            if (this.isClosed) {
                log.warn("The preparedStatement has closed!");
                throw SqlError.createSQLException("No operations allowed after preparedStatement closed.", "S1009");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBounds(int paramIndex) throws SQLException {
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            if (paramIndex < 1) {
                throw SqlError.createSQLException(String.format("Param index out of range, %d < 1.", paramIndex), "S1009");
            }
            if (paramIndex > this.parameterCount) {
                throw SqlError.createSQLException(String.format("Param index out of range, %d > %d.", paramIndex, this.parameterCount), "S1009");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkParamSpecifiedFinished() throws SQLException {
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            if (this.hasSpecifiedParamCount != this.parameterCount) {
                throw SqlError.createSQLException("There are unspecified parameters!", "S1009");
            }
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        this.checkParamSpecifiedFinished();
        String sql = this.asSql();
        return this.connection.execQuerySql(this, sql);
    }

    @Override
    public int executeUpdate() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("executeUpdate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            this.setInternal(parameterIndex, "null", sqlType);
            this.isNull[parameterIndex - 1] = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            this.setInternal(parameterIndex, x ? "1" : "0", 16);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            this.setInternal(parameterIndex, String.valueOf(x), -6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            this.setInternal(parameterIndex, String.valueOf(x), 5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            this.setInternal(parameterIndex, String.valueOf(x), 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            this.setInternal(parameterIndex, String.valueOf(x), -5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            this.setInternal(parameterIndex, String.valueOf(x), 6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            this.setInternal(parameterIndex, String.valueOf(x), 8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            if (x == null) {
                this.setNull(parameterIndex, 3);
                return;
            }
            this.setInternal(parameterIndex, x.toString(), 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            if (x == null) {
                this.setNull(parameterIndex, 12);
                return;
            }
            x = "'" + x + "'";
            this.setInternal(parameterIndex, x, 12);
        }
    }

    private boolean isEscapeNeededForString(String x) {
        if (StringUtils.isBlank(x)) {
            return false;
        }
        boolean needsEscape = false;
        for (int i = 0; i < x.length(); ++i) {
            char c = x.charAt(i);
            switch (c) {
                case '\u0000': 
                case ' ': 
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '\\': 
                case '^': 
                case '_': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    needsEscape = true;
                    break;
                }
            }
            if (needsEscape) break;
        }
        return needsEscape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInternal(int paramIndex, String val, int type) throws SQLException {
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            this.checkClosed();
            this.checkBounds(paramIndex);
            this.parameterValues[paramIndex - 1] = val;
            this.parameterTypes[paramIndex - 1] = type;
            ++this.hasSpecifiedParamCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            if (x == null) {
                this.setNull(parameterIndex, 2003);
                return;
            }
            this.setInternal(parameterIndex, Arrays.toString(x), 2003);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, null);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, null);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PreparedStatementImpl.setAsciiStream");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PreparedStatementImpl.setUnicodeStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PreparedStatementImpl.setBinaryStream");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearParameters() throws SQLException {
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            this.checkClosed();
            for (int i = 0; i < this.parameterValues.length; ++i) {
                this.parameterValues[i] = null;
                this.isNull[i] = false;
                this.parameterTypes[i] = 0;
                this.hasSpecifiedParamCount = 0;
            }
        }
    }

    @Override
    public void setObject(int parameterIndex, Object parameterObj, int targetSqlType) throws SQLException {
        if (!(parameterObj instanceof BigDecimal)) {
            this.setObject(parameterIndex, parameterObj, targetSqlType, 0);
        } else {
            this.setObject(parameterIndex, parameterObj, targetSqlType, ((BigDecimal)parameterObj).scale());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int parameterIndex, Object parameterObj) throws SQLException {
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            if (parameterObj == null) {
                this.setNull(parameterIndex, 1111);
            } else if (parameterObj instanceof Byte) {
                this.setInt(parameterIndex, ((Byte)parameterObj).intValue());
            } else if (parameterObj instanceof String) {
                this.setString(parameterIndex, (String)parameterObj);
            } else if (parameterObj instanceof BigDecimal) {
                this.setBigDecimal(parameterIndex, (BigDecimal)parameterObj);
            } else if (parameterObj instanceof Short) {
                this.setShort(parameterIndex, (Short)parameterObj);
            } else if (parameterObj instanceof Integer) {
                this.setInt(parameterIndex, (Integer)parameterObj);
            } else if (parameterObj instanceof Long) {
                this.setLong(parameterIndex, (Long)parameterObj);
            } else if (parameterObj instanceof Float) {
                this.setFloat(parameterIndex, ((Float)parameterObj).floatValue());
            } else if (parameterObj instanceof Double) {
                this.setDouble(parameterIndex, (Double)parameterObj);
            } else if (parameterObj instanceof byte[]) {
                this.setBytes(parameterIndex, (byte[])parameterObj);
            } else if (parameterObj instanceof Date) {
                this.setDate(parameterIndex, (Date)parameterObj);
            } else if (parameterObj instanceof Time) {
                this.setTime(parameterIndex, (Time)parameterObj);
            } else if (parameterObj instanceof Timestamp) {
                this.setTimestamp(parameterIndex, (Timestamp)parameterObj);
            } else if (parameterObj instanceof Boolean) {
                this.setBoolean(parameterIndex, (Boolean)parameterObj);
            } else if (parameterObj instanceof InputStream) {
                this.setBinaryStream(parameterIndex, (InputStream)parameterObj, -1);
            } else if (parameterObj instanceof Blob) {
                this.setBlob(parameterIndex, (Blob)parameterObj);
            } else if (parameterObj instanceof Clob) {
                this.setClob(parameterIndex, (Clob)parameterObj);
            } else if (parameterObj instanceof java.util.Date) {
                this.setTimestamp(parameterIndex, new Timestamp(((java.util.Date)parameterObj).getTime()));
            } else if (parameterObj instanceof BigInteger) {
                this.setString(parameterIndex, parameterObj.toString());
            } else {
                throw SqlError.createSQLFeatureNotSupportedException("PreparedStatementImpl.setObject, parameterObj:" + parameterObj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        ResultSet newResults = this.executeQuery();
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            this.results = newResults;
            return this.results != null;
        }
    }

    @Override
    public void addBatch() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PrepareStatementImpl.addBatch");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PrepareStatementImpl.setCharacterStream");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PrepareStatementImpl.setRef");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PrepareStatementImpl.setBlob");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PrepareStatementImpl.setClob");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            if (x == null) {
                this.setNull(parameterIndex, 2003);
                return;
            }
            this.setInternal(parameterIndex, x.toString(), 2003);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (null != this.results) {
            return this.results.getMetaData();
        }
        log.info("PreparedStatementImpl.getMetaData, results is null, try execute()");
        boolean hasResult = this.execute();
        if (hasResult) {
            return this.results.getMetaData();
        }
        throw SqlError.createSQLException("getMetaData, execute sql but get null, sql:" + this.asSql(), "S1009");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        log.info("PreparedStatementImpl.setDate, parameterIndex:{}, Date:{}, cal:{}", parameterIndex, x, cal == null ? null : cal.getTimeZone());
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            if (x == null) {
                this.setNull(parameterIndex, 91);
                return;
            }
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
            if (cal == null) {
                String date = dateFormatter.format(x);
                this.setInternal(parameterIndex, date, 91);
                return;
            }
            dateFormatter.setCalendar(cal);
            String date = dateFormatter.format(x);
            this.setInternal(parameterIndex, date, 91);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        log.info("PreparedStatementImpl.setTime, parameterIndex:{}, Time:{}, cal:{}", parameterIndex, x, cal == null ? null : cal.getTimeZone());
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            if (x == null) {
                this.setNull(parameterIndex, 92);
                return;
            }
            SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss");
            if (cal == null) {
                String time = timeFormatter.format(x);
                this.setInternal(parameterIndex, time, 92);
                return;
            }
            timeFormatter.setCalendar((Calendar)cal.clone());
            String time = timeFormatter.format(x);
            this.setInternal(parameterIndex, time, 92);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        log.info("PreparedStatementImpl.setTimestamp, parameterIndex:{}, Timestamp:{}, cal:{}", parameterIndex, x, cal == null ? null : cal.getTimeZone());
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            if (x == null) {
                this.setNull(parameterIndex, 93);
                return;
            }
            SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (cal == null) {
                String timestamp = dateTimeFormatter.format(x);
                this.setInternal(parameterIndex, timestamp, 93);
                return;
            }
            dateTimeFormatter.setCalendar((Calendar)cal.clone());
            String timestamp = dateTimeFormatter.format(x);
            this.setInternal(parameterIndex, timestamp, 93);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PrepareStatementImpl.setURL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        log.info("PrepareStatementImpl.getParameterMetaData");
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            return new ParameterMetaDataImpl(this.parameterCount, this.parameterTypes, this.isNull);
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PrepareStatementImpl.setRef");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PrepareStatementImpl.setNCharacterStream");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PrepareStatementImpl.setNClob");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PrepareStatementImpl.setClob");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PrepareStatementImpl.setBlob");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PrepareStatementImpl.setNClob");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PrepareStatementImpl.setSQLXML");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int parameterIndex, Object parameterObj, int targetSqlType, int scale) throws SQLException {
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            if (parameterObj == null) {
                this.setNull(parameterIndex, 1111);
                return;
            }
            try {
                block3 : switch (targetSqlType) {
                    case 16: {
                        if (parameterObj instanceof Boolean) {
                            this.setBoolean(parameterIndex, (Boolean)parameterObj);
                            break;
                        }
                        if (parameterObj instanceof String) {
                            this.setBoolean(parameterIndex, "true".equalsIgnoreCase((String)parameterObj) || !"0".equalsIgnoreCase((String)parameterObj));
                            break;
                        }
                        if (parameterObj instanceof Number) {
                            int intValue = ((Number)parameterObj).intValue();
                            this.setBoolean(parameterIndex, intValue != 0);
                            break;
                        }
                        throw SqlError.createSQLException("No conversion from " + parameterObj.getClass().getName() + " to Types.BOOLEAN possible.", "S1009");
                    }
                    case -7: 
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.setNumericObject(parameterIndex, parameterObj, targetSqlType, scale);
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        if (parameterObj instanceof BigDecimal) {
                            this.setString(parameterIndex, JdbcUtils.fixDecimalExponent(parameterObj.toString()));
                            break;
                        }
                        this.setString(parameterIndex, parameterObj.toString());
                        break;
                    }
                    case 2005: {
                        if (parameterObj instanceof Clob) {
                            this.setClob(parameterIndex, (Clob)parameterObj);
                            break;
                        }
                        this.setString(parameterIndex, parameterObj.toString());
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2004: {
                        if (parameterObj instanceof byte[]) {
                            this.setBytes(parameterIndex, (byte[])parameterObj);
                            break;
                        }
                        if (parameterObj instanceof Blob) {
                            this.setBlob(parameterIndex, (Blob)parameterObj);
                            break;
                        }
                        this.setString(parameterIndex, parameterObj.toString());
                        break;
                    }
                    case 91: 
                    case 93: {
                        java.util.Date parameterAsDate;
                        if (parameterObj instanceof String) {
                            SimpleDateFormat sdf = new SimpleDateFormat(this.getDateTimePattern((String)parameterObj, true));
                            parameterAsDate = sdf.parse((String)parameterObj);
                        } else {
                            parameterAsDate = (java.util.Date)parameterObj;
                        }
                        switch (targetSqlType) {
                            case 91: {
                                if (parameterAsDate instanceof Date) {
                                    this.setDate(parameterIndex, (Date)parameterAsDate);
                                    break block3;
                                }
                                this.setDate(parameterIndex, new Date(parameterAsDate.getTime()));
                                break block3;
                            }
                            case 93: {
                                if (parameterAsDate instanceof Timestamp) {
                                    this.setTimestamp(parameterIndex, (Timestamp)parameterAsDate);
                                    break block3;
                                }
                                this.setTimestamp(parameterIndex, new Timestamp(parameterAsDate.getTime()));
                                break block3;
                            }
                        }
                        break;
                    }
                    case 92: {
                        if (parameterObj instanceof String) {
                            SimpleDateFormat sdf = new SimpleDateFormat(this.getDateTimePattern((String)parameterObj, true));
                            this.setTime(parameterIndex, new Time(sdf.parse((String)parameterObj).getTime()));
                            break;
                        }
                        if (parameterObj instanceof Timestamp) {
                            Timestamp xT = (Timestamp)parameterObj;
                            this.setTime(parameterIndex, new Time(xT.getTime()));
                            break;
                        }
                        this.setTime(parameterIndex, (Time)parameterObj);
                        break;
                    }
                    case 1111: {
                        this.setObject(parameterIndex, parameterObj);
                        break;
                    }
                    default: {
                        throw SqlError.createSQLException("PreparedStatement.setObject unknown targetSqlType:" + targetSqlType, "S1000");
                    }
                }
            }
            catch (Exception ex) {
                if (ex instanceof SQLException) {
                    throw (SQLException)ex;
                }
                SQLException sqlEx = SqlError.createSQLException("PreparedStatement.setObject Exception, parameterObj:" + parameterObj.getClass().toString() + ex.getMessage(), "S1000");
                sqlEx.initCause(ex);
                throw sqlEx;
            }
        }
    }

    private void setNumericObject(int parameterIndex, Object parameterObj, int targetSqlType, int scale) throws SQLException {
        Number parameterAsNum;
        if (parameterObj instanceof Boolean) {
            parameterAsNum = (Boolean)parameterObj != false ? Integer.valueOf(1) : Integer.valueOf(0);
        } else if (parameterObj instanceof String) {
            switch (targetSqlType) {
                case -7: {
                    String stringOne = "1";
                    String stringZero = "0";
                    if (stringOne.equals(parameterObj) || stringZero.equals(parameterObj)) {
                        parameterAsNum = Integer.valueOf((String)parameterObj);
                        break;
                    }
                    boolean parameterAsBoolean = "true".equalsIgnoreCase((String)parameterObj);
                    parameterAsNum = parameterAsBoolean ? Integer.valueOf(1) : Integer.valueOf(0);
                    break;
                }
                case -6: 
                case 4: 
                case 5: {
                    parameterAsNum = Integer.valueOf((String)parameterObj);
                    break;
                }
                case -5: {
                    parameterAsNum = Long.valueOf((String)parameterObj);
                    break;
                }
                case 7: {
                    parameterAsNum = Float.valueOf((String)parameterObj);
                    break;
                }
                case 6: 
                case 8: {
                    parameterAsNum = Double.valueOf((String)parameterObj);
                    break;
                }
                default: {
                    parameterAsNum = new BigDecimal((String)parameterObj);
                    break;
                }
            }
        } else {
            parameterAsNum = (Number)parameterObj;
        }
        switch (targetSqlType) {
            case -7: 
            case -6: 
            case 4: 
            case 5: {
                this.setInt(parameterIndex, parameterAsNum.intValue());
                break;
            }
            case -5: {
                this.setLong(parameterIndex, parameterAsNum.longValue());
                break;
            }
            case 7: {
                this.setFloat(parameterIndex, parameterAsNum.floatValue());
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(parameterIndex, parameterAsNum.doubleValue());
                break;
            }
            case 2: 
            case 3: {
                if (parameterAsNum instanceof BigDecimal) {
                    BigDecimal scaledBigDecimal = null;
                    try {
                        scaledBigDecimal = ((BigDecimal)parameterAsNum).setScale(scale);
                    }
                    catch (ArithmeticException ex) {
                        try {
                            scaledBigDecimal = ((BigDecimal)parameterAsNum).setScale(scale, 4);
                        }
                        catch (ArithmeticException arEx) {
                            throw SqlError.createSQLException("Can't set scale of '" + scale + "' for DECIMAL argument '" + parameterAsNum + "'", "S1009");
                        }
                    }
                    this.setBigDecimal(parameterIndex, scaledBigDecimal);
                    break;
                }
                if (parameterAsNum instanceof BigInteger) {
                    this.setBigDecimal(parameterIndex, new BigDecimal((BigInteger)parameterAsNum, scale));
                    break;
                }
                this.setBigDecimal(parameterIndex, new BigDecimal(parameterAsNum.doubleValue()));
                break;
            }
        }
    }

    private String getDateTimePattern(String dt, boolean toTime) throws Exception {
        int i;
        int size;
        char c;
        int n;
        Object[] v;
        int z;
        int dtLength = dt != null ? dt.length() : 0;
        int dtLengthMin = 8;
        int dtLengthMax = 10;
        if (dtLength >= dtLengthMin && dtLength <= dtLengthMax) {
            int dashCount = 0;
            boolean isDateOnly = true;
            for (int i2 = 0; i2 < dtLength; ++i2) {
                char c2 = dt.charAt(i2);
                if (!Character.isDigit(c2) && c2 != '-') {
                    isDateOnly = false;
                    break;
                }
                if (c2 != '-') continue;
                ++dashCount;
            }
            int dtDashCount = 2;
            if (isDateOnly && dashCount == dtDashCount) {
                return "yyyy-MM-dd";
            }
        }
        boolean colonsOnly = true;
        for (int i3 = 0; i3 < dtLength; ++i3) {
            char c3 = dt.charAt(i3);
            if (Character.isDigit(c3) || c3 == ':') continue;
            colonsOnly = false;
            break;
        }
        if (colonsOnly) {
            return "HH:mm:ss";
        }
        StringReader reader = new StringReader(dt + " ");
        ArrayList<Object[]> vec = new ArrayList<Object[]>();
        ArrayList<Object[]> vecRemovelist = new ArrayList<Object[]>();
        Object[] nv = new Object[]{Character.valueOf('y'), new StringBuilder(), 0};
        vec.add(nv);
        if (toTime) {
            nv = new Object[]{Character.valueOf('h'), new StringBuilder(), 0};
            vec.add(nv);
        }
        while ((z = reader.read()) != -1) {
            char separator = (char)z;
            int maxvecs = vec.size();
            for (int count = 0; count < maxvecs; ++count) {
                v = (Object[])vec.get(count);
                n = (Integer)v[2];
                c = this.getSuccessor(((Character)v[0]).charValue(), n);
                if (!Character.isLetterOrDigit(separator)) {
                    if (c == ((Character)v[0]).charValue() && c != 'S') {
                        vecRemovelist.add(v);
                        continue;
                    }
                    ((StringBuilder)v[1]).append(separator);
                    if (c != 'X' && c != 89) continue;
                    v[2] = 4;
                    continue;
                }
                if (c == 'X') {
                    c = 'y';
                    nv = new Object[3];
                    nv[1] = new StringBuilder(((StringBuilder)v[1]).toString()).append('M');
                    nv[0] = Character.valueOf('M');
                    nv[2] = 1;
                    vec.add(nv);
                } else if (c == 'Y') {
                    c = 'M';
                    nv = new Object[3];
                    nv[1] = new StringBuilder(((StringBuilder)v[1]).toString()).append('d');
                    nv[0] = Character.valueOf('d');
                    nv[2] = 1;
                    vec.add(nv);
                }
                ((StringBuilder)v[1]).append(c);
                if (c == ((Character)v[0]).charValue()) {
                    v[2] = n + 1;
                    continue;
                }
                v[0] = Character.valueOf(c);
                v[2] = 1;
            }
            size = vecRemovelist.size();
            for (i = 0; i < size; ++i) {
                v = (Object[])vecRemovelist.get(i);
                vec.remove(v);
            }
            vecRemovelist.clear();
        }
        size = vec.size();
        for (i = 0; i < size; ++i) {
            boolean res;
            v = (Object[])vec.get(i);
            c = ((Character)v[0]).charValue();
            boolean bk = this.getSuccessor(c, n = ((Integer)v[2]).intValue()) != c;
            boolean atEnd = (c == 's' || c == 'm' || c == 'h' && toTime) && bk;
            boolean finishesAtDate = bk && c == 'd' && !toTime;
            boolean containsEnd = ((StringBuilder)v[1]).toString().indexOf(87) != -1;
            boolean bl = res = !atEnd && !finishesAtDate || containsEnd;
            if (!res) continue;
            vecRemovelist.add(v);
        }
        size = vecRemovelist.size();
        for (i = 0; i < size; ++i) {
            vec.remove(vecRemovelist.get(i));
        }
        vecRemovelist.clear();
        v = (Object[])vec.get(0);
        StringBuilder format = (StringBuilder)v[1];
        format.setLength(format.length() - 1);
        return format.toString();
    }

    private final char getSuccessor(char c, int n) {
        int two = 2;
        int three = 3;
        int four = 4;
        char y = 'y';
        char d = 'd';
        char m = 'm';
        char s = 's';
        char mCaps = 'M';
        char hCaps = 'H';
        if (c == y && n == two) {
            return 'X';
        }
        if (c == y && n < four) {
            return 'y';
        }
        if (c == y) {
            return 'M';
        }
        if (c == mCaps && n == two) {
            return 'Y';
        }
        if (c == mCaps && n < three) {
            return 'M';
        }
        if (c == mCaps) {
            return 'd';
        }
        if (c == d && n < two) {
            return 'd';
        }
        if (c == d) {
            return 'H';
        }
        if (c == hCaps && n < two) {
            return 'H';
        }
        if (c == hCaps) {
            return 'm';
        }
        if (c == m && n < two) {
            return 'm';
        }
        if (c == m) {
            return 's';
        }
        if (c == s && n < two) {
            return 's';
        }
        return 'W';
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("setAsciiStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("setBinaryStream");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("setCharacterStream");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("setAsciiStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("setBinaryStream");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("setCharacterStream");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("setNCharacterStream");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("setClob");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("setBlob");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("setNClob");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PrepareStatementImpl.executeQuery");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("executeUpdate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        log.info("PrepareStatementImpl.close");
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            this.isClosed = true;
            this.results = null;
            this.connection = null;
            this.parameterValues = null;
            this.isNull = null;
            this.parameterTypes = null;
            this.staticSql = null;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        log.info("PreparedStatementImpl.setEscapeProcessing");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 300;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        log.info("PreparedStatementImpl.setQueryTimeout");
    }

    @Override
    public void cancel() throws SQLException {
        log.info("PreparedStatementImpl.cancel");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        log.info("StatementImpl.getWarnings");
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        log.info("StatementImpl.setCursorName");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PreparedStatementImpl.execute");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getResultSet() throws SQLException {
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            ResultSet res = this.results;
            this.results = null;
            return res;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchDirection(int direction) throws SQLException {
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            ResultSetImpl.checkSupportFetchDirection(direction);
            this.fetchDirection = direction;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PreparedStatementImpl.addBatch");
    }

    @Override
    public void clearBatch() throws SQLException {
        log.info("PreparedStatementImpl.clearBatch");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PreparedStatementImpl.executeBatch");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        log.info("PreparedStatementImpl.getMoreResults");
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        QueryResponse queryResponse = new QueryResponse();
        ArrayList<String> columns = new ArrayList<String>(4);
        columns.add("GENERATED_KEY");
        ArrayList<String> metadata = new ArrayList<String>(4);
        metadata.add("VARCHAR");
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(0);
        queryResponse.setColumns(columns);
        queryResponse.setMetadata(metadata);
        queryResponse.setRows(rows);
        return new ResultSetImpl(this.connection, this.connection.getPrivateStatement(), queryResponse);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PreparedStatementImpl.executeUpdate");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PreparedStatementImpl.executeUpdate");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PreparedStatementImpl.executeUpdate");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PreparedStatementImpl.execute");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PreparedStatementImpl.execute");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("PreparedStatementImpl.execute");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("unwrap");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

