/*
 * Decompiled with CFR 0.152.
 */
package com.eniot.data.query.impl;

import com.eniot.data.query.entity.EnosResponse;
import com.eniot.data.query.entity.ListChannelResp;
import com.eniot.data.query.entity.QueryResponse;
import com.eniot.data.query.entity.SupportedDataSoureTypeEnum;
import com.eniot.data.query.exception.SqlError;
import com.envision.apim.poseidon.config.PConfig;
import com.envision.apim.poseidon.core.Poseidon;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClient {
    private static final Logger log = LoggerFactory.getLogger(RestClient.class);
    private String orgId = null;
    private String host;
    private String chId;
    private String source = null;
    private volatile boolean connected = false;
    private String user;
    private String password;
    private PConfig.ProxyConfig proxyConfig;
    private String httpPrefix = "https://";
    private String dataStorageManager = "data-storage-manager";
    private String bear = "Bearer ";
    private Gson gson = new Gson();
    private static RestClient restClient;
    private String apimQueryUrl;
    private String apimLoginUrl;
    private String apimRefreshTokenUrl;
    private String apimListChannelsUrl;
    private Set<String> supportedDataSourceNameSet = new HashSet<String>(2);
    private static final String SHOW_DATABASES = "show databases";
    private static final String SHOW_SCHEMAS = "show schemas";
    private static final String SCHEMA_NAME = "SCHEMA_NAME";
    private static final String SHOW_FILES = "show files";
    private static final String SHOW_TABLES = "show tables";
    private static final String DESC = "desc";

    private RestClient(String host, String chId, Properties info) {
        this.user = info.getProperty("user");
        this.password = info.getProperty("password");
        this.chId = chId;
        this.source = info.getProperty("source");
        this.host = host;
        this.orgId = info.getProperty("orgId");
        String proxyIp = info.getProperty("proxyIp");
        String proxyPort = info.getProperty("proxyPort");
        if (proxyIp != null && proxyPort != null) {
            this.proxyConfig = new PConfig.ProxyConfig(proxyIp, Integer.parseInt(proxyPort));
        }
        this.apimQueryUrl = this.httpPrefix + host + "?orgId=" + this.orgId;
        this.apimLoginUrl = this.httpPrefix + host.substring(0, host.indexOf(47)) + "/apim-token-service/v2.0/token/get";
        this.apimRefreshTokenUrl = this.httpPrefix + host.substring(0, host.indexOf(47)) + "/apim-token-service/v2.0/token/refresh";
        this.apimListChannelsUrl = this.httpPrefix + host.substring(0, host.lastIndexOf("/read")) + "?orgId=" + this.orgId + "&channelType=READ";
        log.info("apimQueryUrl:{}", (Object)this.apimQueryUrl);
        log.info("apimLoginUrl:{}", (Object)this.apimLoginUrl);
        log.info("apimRefreshTokenUrl:{}", (Object)this.apimRefreshTokenUrl);
        log.info("apimListChannelsUrl:{}", (Object)this.apimListChannelsUrl);
    }

    public static synchronized RestClient getRestClient(String host, String chId, Properties info) throws SQLException {
        if (restClient == null || RestClient.resetLoginInfoNeeded(host, chId, info)) {
            restClient = new RestClient(host, chId, info);
            restClient.connect();
        }
        return restClient;
    }

    private static boolean resetLoginInfoNeeded(String host, String chId, Properties info) {
        if (!RestClient.restClient.host.equals(host) || !RestClient.restClient.chId.equals(chId)) {
            return true;
        }
        if (!RestClient.restClient.orgId.equals(info.getProperty("orgId"))) {
            return true;
        }
        return !RestClient.restClient.user.equals(info.getProperty("user")) || !RestClient.restClient.password.equals(info.getProperty("password"));
    }

    private void connect() throws SQLException {
        if (this.connected) {
            return;
        }
        this.apimCheckChannelsInfo();
        this.connected = true;
        log.info("Successfully connected to query server");
    }

    public QueryResponse execQuery(String sql) throws SQLException {
        return this.execApimQuery(sql);
    }

    private void apimCheckChannelsInfo() throws SQLException {
        log.info("RestClient.apimCheckChannelsInfo");
        try {
            String response = Poseidon.config(PConfig.init().appKey(this.user).appSecret(this.password).proxyConfig(this.proxyConfig).connectTimeout(0L).readTimeout(0L).writeTimeout(0L)).url(this.apimListChannelsUrl).header("Content-Type", "application/json").method("GET").sync();
            ListChannelResp listChannelResp = this.gson.fromJson(response, ListChannelResp.class);
            if (listChannelResp.getCode() != 0) {
                log.error("RestClient apimCheckChannelsInfo failed!, apimListChannelsUrl = {}, response = {}", (Object)this.apimListChannelsUrl, (Object)response);
                throw SqlError.createSQLException(String.format("CheckChannelsInfo failed! code = %d, msg = %s.", listChannelResp.getCode(), listChannelResp.getMsg()), "08001");
            }
            if (listChannelResp.getData() != null && !listChannelResp.getData().isEmpty()) {
                for (ListChannelResp.ChannelDataInfo channelDataInfo : listChannelResp.getData()) {
                    if (!this.chId.equals(channelDataInfo.getChannelId()) || channelDataInfo.getDataSourceInfo() == null || listChannelResp.getData().isEmpty()) continue;
                    for (ListChannelResp.DataSourceInfo dataSourceInfo : channelDataInfo.getDataSourceInfo()) {
                        if (SupportedDataSoureTypeEnum.getSupportedDataSoureType(dataSourceInfo.getDataSourceType()) == null) continue;
                        this.supportedDataSourceNameSet.add(dataSourceInfo.getAlias());
                    }
                }
            }
            if (this.supportedDataSourceNameSet.isEmpty()) {
                log.error("No valid data source was found for chId = {}!", (Object)this.chId);
                throw SqlError.createSQLException(String.format("No valid data source was found for chId = %s!", this.chId), "08001");
            }
        }
        catch (SQLException sqlException) {
            throw sqlException;
        }
        catch (Exception e) {
            log.error("RestClient apimCheckChannelsInfo error, apimListChannelsUrl = {}, exception: {}", (Object)this.apimListChannelsUrl, (Object)e);
            throw SqlError.createSQLException("apimCheckChannelsInfo error! " + e.getMessage(), "08001");
        }
    }

    private QueryResponse execApimQuery(String sql) throws SQLException {
        log.info("RestClient.execApimQuery, sql:{}", (Object)sql);
        String resp = "";
        try {
            long refreshDiffTimeMax = 600000L;
            resp = this.apimQuery(sql, this.source);
            EnosResponse enosResponse = this.gson.fromJson(resp, EnosResponse.class);
            if (enosResponse.getCode() == 81403) {
                resp = this.apimQuery(sql, this.source);
                enosResponse = this.gson.fromJson(resp, EnosResponse.class);
            }
            if (enosResponse.getCode() == 0) {
                if ((SHOW_SCHEMAS.equals(sql.toLowerCase(Locale.ENGLISH)) || SHOW_DATABASES.equals(sql.toLowerCase(Locale.ENGLISH))) && this.source == null) {
                    return this.filterDatabaseRows(enosResponse.getData());
                }
                return enosResponse.getData();
            }
            if (enosResponse.getCode() == 81530) {
                log.error("RestClient execApimQuery failed, status = {}, msg = {}", (Object)enosResponse.getCode(), (Object)"Illegal sql");
                throw SqlError.createSQLException(String.format("execApimQuery failed! status = %d, msg = %s.", enosResponse.getCode(), "Illegal sql"), "S0500");
            }
            log.error("RestClient execApimQuery failed, status = {}, msg = {}", (Object)enosResponse.getCode(), (Object)enosResponse.getMsg());
            throw SqlError.createSQLException(String.format("execApimQuery failed! status = %d, msg = %s.", enosResponse.getCode(), enosResponse.getMsg()), "S0500");
        }
        catch (SQLException sqlException) {
            throw sqlException;
        }
        catch (Exception e) {
            log.error("RestClient execApimQuery error!, apimQueryUrl:{}, resp:{}, exception:{}", this.apimQueryUrl, resp, e);
            throw SqlError.createSQLException("execQuery error! " + e.getMessage(), "S0500");
        }
    }

    private String apimQuery(String sql, String source) {
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("sqlQuery", sql);
        if (source != null) {
            requestBody.addProperty("source", source);
        }
        return Poseidon.config(PConfig.init().appKey(this.user).appSecret(this.password).proxyConfig(this.proxyConfig).connectTimeout(0L).readTimeout(0L).writeTimeout(0L)).url(this.apimQueryUrl).requestBody(requestBody.toString()).method("POST").sync();
    }

    private QueryResponse filterDatabaseRows(QueryResponse queryResponse) {
        if (queryResponse == null || queryResponse.getRows() == null || queryResponse.getRows().isEmpty()) {
            return queryResponse;
        }
        ArrayList<Map<String, Object>> rowsNew = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> row : queryResponse.getRows()) {
            String dataSourceName;
            String schema = (String)row.get(SCHEMA_NAME);
            if (!StringUtils.isNotBlank(schema) || !schema.contains(".") || !this.supportedDataSourceNameSet.contains(dataSourceName = schema.substring(0, schema.indexOf(46)))) continue;
            rowsNew.add(row);
        }
        queryResponse.setRows(rowsNew);
        return queryResponse;
    }
}

