/*
 * Decompiled with CFR 0.152.
 */
package com.eniot.data.query.impl;

import com.eniot.data.query.EniotConnect;
import com.eniot.data.query.EniotResultSet;
import com.eniot.data.query.entity.DataType;
import com.eniot.data.query.entity.QueryResponse;
import com.eniot.data.query.exception.SqlError;
import com.eniot.data.query.impl.ResultSetMetaDataImpl;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetImpl
implements EniotResultSet {
    private static final Logger log = LoggerFactory.getLogger(ResultSetImpl.class);
    private Integer index = 0;
    private EniotConnect connect;
    private Statement statement;
    private String catalog;
    private boolean isClosed = false;
    private boolean wasNullFlag = false;
    private boolean isBeforeFirst = false;
    private boolean isAfterLast = false;
    private int fetchSize = 640000;
    private List<String> columns;
    private List<Integer> metaType;
    private List<Map<String, Object>> rows;
    private Map<String, Integer> columnNameToIndex;
    private int fetchDirection = 1000;
    Calendar defaultCalendar = new GregorianCalendar();
    private static Pattern DATE_TIME_PATTERN = Pattern.compile("^(\\d{4}-\\d{2}-\\d{2}\\s\\d{2}:\\d{2}:\\d{2})(\\.\\d{1,3}?)?$");
    private static Pattern DATE_TIME_PATTERN_T = Pattern.compile("^(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2})(\\.\\d{1,3}?)?$");
    private static Pattern DATE_PATTERN = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}$");
    private static Pattern TIME_PATTERN = Pattern.compile("^(\\d{2}:\\d{2}:\\d{2})(\\.\\d{1,3}?)?$");
    private static Pattern DATE_PATTERN_T = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}$");
    private static Pattern DATE_PATTERN_Z = Pattern.compile("^(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2})(\\.\\d{1,3}\\+\\d{1,4})?$");
    private Boolean onValidRow = false;
    private String invalidRowReason = "On valid row";

    public ResultSetImpl(EniotConnect connect, Statement statement, QueryResponse queryResponse) throws SQLException {
        this.connect = connect;
        this.statement = statement;
        this.columns = queryResponse.getColumns();
        this.rows = queryResponse.getRows();
        this.catalog = connect.getCatalog();
        this.metaType = this.formatDataMetaType(queryResponse.getColumns(), queryResponse.getMetadata());
        this.columnNameToIndex = this.initColumnNameMap(this.columns);
    }

    private List<Integer> formatDataMetaType(List<String> columns, List<String> metadata) {
        if (null == columns || columns.isEmpty()) {
            return null;
        }
        if (null == metadata || metadata.isEmpty()) {
            return null;
        }
        ArrayList<Integer> metaType = new ArrayList<Integer>(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            String meta = metadata.get(i);
            if (meta.startsWith(DataType.VARCHAR.getType())) {
                metaType.add(12);
                continue;
            }
            if (meta.startsWith(DataType.BIT.getType())) {
                metaType.add(-7);
                continue;
            }
            if (meta.startsWith(DataType.INT.getType())) {
                metaType.add(4);
                continue;
            }
            if (meta.startsWith(DataType.BIGINT.getType())) {
                metaType.add(-5);
                continue;
            }
            if (meta.startsWith(DataType.DOUBLE.getType())) {
                metaType.add(8);
                continue;
            }
            if (meta.startsWith(DataType.FLOAT.getType())) {
                metaType.add(6);
                continue;
            }
            if (meta.startsWith(DataType.DATE.getType())) {
                metaType.add(91);
                continue;
            }
            if (meta.startsWith(DataType.TIMESTAMP.getType())) {
                metaType.add(93);
                continue;
            }
            if (meta.startsWith(DataType.TIME.getType())) {
                metaType.add(92);
                continue;
            }
            metaType.add(12);
        }
        return metaType;
    }

    private Map<String, Integer> initColumnNameMap(List<String> columns) {
        if (null == columns || columns.isEmpty()) {
            return null;
        }
        HashMap<String, Integer> columnNameToIndex = new HashMap<String, Integer>(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            columnNameToIndex.put(columns.get(i), i);
        }
        return columnNameToIndex;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            log.warn("ResultSet has closed!");
            throw SqlError.createSQLException("Operation not allowed after ResultSet closed", "S1009");
        }
    }

    private void checkColumnBounds(int columnIndex) throws SQLException {
        if (columnIndex < 1) {
            throw SqlError.createSQLException(String.format("Column index out of range, %d < 1.", columnIndex), "S1009");
        }
        if (columnIndex > this.columns.size()) {
            throw SqlError.createSQLException(String.format("Column index out of range, %d > %d.", columnIndex, this.columns.size()), "S1009");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRowPositionValidity() throws SQLException {
        ResultSetImpl resultSetImpl = this;
        synchronized (resultSetImpl) {
            if (this.rows == null || this.rows.isEmpty()) {
                this.onValidRow = false;
                this.invalidRowReason = "Illegal operation on empty result set";
            } else if (this.isBeforeFirst) {
                this.onValidRow = false;
                this.invalidRowReason = "Before start of result set";
            } else if (this.isAfterLast) {
                this.onValidRow = false;
                this.invalidRowReason = "After end of result set";
            }
            this.onValidRow = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRowPos() throws SQLException {
        ResultSetImpl resultSetImpl = this;
        synchronized (resultSetImpl) {
            this.checkClosed();
            if (!this.onValidRow.booleanValue()) {
                throw SqlError.createSQLException(this.invalidRowReason, "S1000");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SQLException {
        if (this.rows == null || this.rows.isEmpty()) {
            return false;
        }
        ResultSetImpl resultSetImpl = this;
        synchronized (resultSetImpl) {
            if (this.index + 1 <= this.rows.size()) {
                this.setRowPositionValidity();
                ResultSetImpl resultSetImpl2 = this;
                Integer n = resultSetImpl2.index;
                Integer n2 = resultSetImpl2.index = Integer.valueOf(resultSetImpl2.index + 1);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        log.info("ResultSetImpl.close");
        ResultSetImpl resultSetImpl = this;
        synchronized (resultSetImpl) {
            if (this.isClosed) {
                return;
            }
            this.columns = null;
            this.rows = null;
            this.statement = null;
            this.connect = null;
            this.metaType = null;
            this.onValidRow = false;
            this.columnNameToIndex = null;
            this.isClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasNull() throws SQLException {
        ResultSetImpl resultSetImpl = this;
        synchronized (resultSetImpl) {
            boolean wnf = this.wasNullFlag;
            this.wasNullFlag = false;
            return wnf;
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        return value == null ? null : String.valueOf(value);
    }

    private String getColumnNameByIndex(int columnIndex) throws SQLException {
        if (null == this.columns || this.columns.isEmpty()) {
            throw SqlError.createSQLException("Illegal operation on empty result set!", "S0222");
        }
        this.checkColumnBounds(columnIndex);
        return this.columns.get(columnIndex - 1);
    }

    private Integer getColumnDataTypeByIndex(int columnIndex) throws SQLException {
        if (null == this.metaType || this.metaType.isEmpty()) {
            throw SqlError.createSQLException("ResultSet is empty!", "S0222");
        }
        this.checkColumnBounds(columnIndex);
        return this.metaType.get(columnIndex - 1);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Integer columnDataType = this.getColumnDataTypeByIndex(columnIndex);
        switch (columnDataType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                long longVal = this.getLong(columnIndex);
                return longVal == -1L || longVal > 0L;
            }
        }
        String stringVal = this.getString(columnIndex);
        return this.getBooleanFromString(stringVal);
    }

    private boolean getBooleanFromString(String stringVal) throws SQLException {
        if (stringVal != null && stringVal.length() > 0) {
            char c = Character.toLowerCase(stringVal.charAt(0));
            return c == 't' || c == 'y' || c == '1' || "-1".equals(stringVal);
        }
        return false;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        String val = this.getString(columnIndex);
        if (val == null) {
            return 0;
        }
        if (val.length() == 0) {
            this.convertToZeroWithEmptyCheck();
        }
        try {
            double valueAsDouble = Double.parseDouble(val);
            return (byte)valueAsDouble;
        }
        catch (NumberFormatException nfe) {
            throw SqlError.createSQLException(String.format("Invalid value for getByte(), value:%s", val), "S1009");
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        String val = this.getString(columnIndex);
        if (val == null) {
            return 0;
        }
        if (val.length() == 0) {
            this.convertToZeroWithEmptyCheck();
        }
        try {
            double valueAsDouble = Double.parseDouble(val);
            return (short)valueAsDouble;
        }
        catch (NumberFormatException nfe) {
            throw SqlError.createSQLException(String.format("Invalid value for getShort(), value:%s", val), "S1009");
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        String val = this.getString(columnIndex);
        if (val == null) {
            return 0;
        }
        if (val.length() == 0) {
            this.convertToZeroWithEmptyCheck();
        }
        try {
            double valueAsDouble = Double.parseDouble(val);
            return (int)valueAsDouble;
        }
        catch (NumberFormatException nfe) {
            String yesKey = "YES";
            String noKey = "NO";
            if (yesKey.equalsIgnoreCase(val)) {
                return 1;
            }
            if (noKey.equalsIgnoreCase(val)) {
                return 0;
            }
            throw SqlError.createSQLException(String.format("Invalid value for getInt(), column:%s, value:%s, type:%d", this.getColumnNameByIndex(columnIndex), val, this.getColumnDataTypeByIndex(columnIndex)), "S1009");
        }
    }

    private void convertToZeroWithEmptyCheck() throws SQLException {
        throw SqlError.createSQLException("Can't convert empty string ('') to numeric", "22018");
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        String val = this.getString(columnIndex);
        if (val == null) {
            return 0L;
        }
        if (val.length() == 0) {
            this.convertToZeroWithEmptyCheck();
        }
        try {
            double valueAsDouble = Double.parseDouble(val);
            return (long)valueAsDouble;
        }
        catch (NumberFormatException nfe) {
            throw SqlError.createSQLException(String.format("Invalid value for getLong(), value:%s", val), "S1009");
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        String val = this.getString(columnIndex);
        if (val == null) {
            return 0.0f;
        }
        if (val.length() == 0) {
            this.convertToZeroWithEmptyCheck();
        }
        try {
            double valueAsDouble = Double.parseDouble(val);
            return (float)valueAsDouble;
        }
        catch (NumberFormatException nfe) {
            throw SqlError.createSQLException(String.format("Invalid value for getFloat(), value:%s", val), "S1009");
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        String val = this.getString(columnIndex);
        if (val == null) {
            return 0.0;
        }
        if (val.length() == 0) {
            this.convertToZeroWithEmptyCheck();
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException nfe) {
            throw SqlError.createSQLException(String.format("Invalid value for getDouble(), value:%s", val), "S1009");
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal val = this.getBigDecimal(columnIndex);
        return val == null ? null : val.setScale(scale);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        String val = this.getString(columnIndex);
        return val == null ? null : val.getBytes();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, null);
    }

    private java.util.Date formatUtilDate(String dateValue, Calendar cal) throws SQLException {
        if (dateValue == null) {
            return null;
        }
        java.util.Date utilDate = null;
        try {
            if (cal == null) {
                cal = this.defaultCalendar;
            }
            if (DATE_TIME_PATTERN.matcher(dateValue).matches()) {
                SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                dateTimeFormatter.setCalendar(cal);
                utilDate = dateTimeFormatter.parse(dateValue);
            } else if (DATE_TIME_PATTERN_T.matcher(dateValue).matches()) {
                SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                dateTimeFormatter.setCalendar(cal);
                utilDate = dateTimeFormatter.parse(dateValue.replace("T", " "));
            } else if (DATE_PATTERN.matcher(dateValue).matches()) {
                SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
                dateFormatter.setCalendar(cal);
                utilDate = dateFormatter.parse(dateValue);
            } else if (DATE_PATTERN_T.matcher(dateValue).matches()) {
                dateValue = dateValue.replace("T", " ");
                dateValue = dateValue + ":00";
                SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                dateTimeFormatter.setCalendar(cal);
                utilDate = dateTimeFormatter.parse(dateValue);
            } else if (TIME_PATTERN.matcher(dateValue).matches()) {
                SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss");
                timeFormatter.setCalendar(cal);
                utilDate = new Date(timeFormatter.parse(dateValue).getTime());
            } else if (DATE_PATTERN_Z.matcher(dateValue).matches()) {
                SimpleDateFormat timeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS+SSSS");
                timeFormatter.setCalendar(cal);
                utilDate = new Date(timeFormatter.parse(dateValue).getTime());
            } else {
                log.warn("ResultSetImpl.formatUtilDate, nonsupport date format, dateValue:{}", (Object)dateValue);
            }
        }
        catch (ParseException parseException) {
            log.warn("ResultSetImpl.formatUtilDate parse date exception", parseException);
            throw SqlError.createSQLException("ResultSetImpl.formatUtilDate parse date exception" + parseException.getMessage(), "S2009");
        }
        return utilDate;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, null);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, null);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        log.info("ResultSetImpl.getAsciiStream");
        throw SqlError.createSQLFeatureNotSupportedException("getAsciiStream");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        log.info("ResultSetImpl.getUnicodeStream");
        throw SqlError.createSQLFeatureNotSupportedException("getUnicodeStream");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        log.info("ResultSetImpl.getBinaryStream");
        throw SqlError.createSQLFeatureNotSupportedException("getBinaryStream");
    }

    private int findColumnIndex(String column) throws SQLException {
        Integer index = this.columnNameToIndex.get(column);
        if (null != index) {
            return index + 1;
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!this.columns.get(i).equalsIgnoreCase(column)) continue;
            return i + 1;
        }
        throw SqlError.createSQLException(String.format("ResultSet columnName: %s, not found.", column), "S0022");
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumnIndex(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumnIndex(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumnIndex(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumnIndex(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumnIndex(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumnIndex(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumnIndex(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumnIndex(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumnIndex(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumnIndex(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumnIndex(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumnIndex(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumnIndex(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumnIndex(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumnIndex(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumnIndex(columnLabel));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        log.info("ResultSetImpl.getWarnings");
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        log.info("ResultSetImpl.clearWarnings");
    }

    @Override
    public String getCursorName() throws SQLException {
        log.info("ResultSetImpl.getCursorName");
        return null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        log.info("ResultSetImpl.getMetaData");
        return new ResultSetMetaDataImpl(this, this.columns, this.metaType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkRowPos();
        String columnName = this.getColumnNameByIndex(columnIndex);
        ResultSetImpl resultSetImpl = this;
        synchronized (resultSetImpl) {
            Map<String, Object> row = this.rows.get(this.index - 1);
            Object value = row.get(columnName);
            if (null == value) {
                this.wasNullFlag = true;
                return null;
            }
            return value;
        }
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumnIndex(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.findColumnIndex(columnLabel);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        log.info("ResultSetImpl.getCharacterStream");
        throw SqlError.createSQLFeatureNotSupportedException("getCharacterStream");
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumnIndex(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        String stringValue = this.getString(columnIndex);
        BigDecimal val = null;
        if (null != stringValue) {
            if (stringValue.length() == 0) {
                val = new BigDecimal("0");
            } else {
                try {
                    val = new BigDecimal(stringValue);
                }
                catch (NumberFormatException ex) {
                    throw SqlError.createSQLException(String.format("ResultSet.Bad_format_for_BigDecimal, columnIndex = %d, value = %s.", columnIndex, stringValue), "S1009");
                }
            }
        }
        return val;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumnIndex(columnLabel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBeforeFirst() throws SQLException {
        log.info("ResultSetImpl.isBeforeFirst");
        ResultSetImpl resultSetImpl = this;
        synchronized (resultSetImpl) {
            this.checkClosed();
            return this.isBeforeFirst;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfterLast() throws SQLException {
        log.info("ResultSetImpl.isAfterLast");
        ResultSetImpl resultSetImpl = this;
        synchronized (resultSetImpl) {
            this.checkClosed();
            return this.isAfterLast;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFirst() throws SQLException {
        log.info("ResultSetImpl.isFirst");
        ResultSetImpl resultSetImpl = this;
        synchronized (resultSetImpl) {
            this.checkClosed();
            return this.index == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLast() throws SQLException {
        log.info("ResultSetImpl.isLast");
        ResultSetImpl resultSetImpl = this;
        synchronized (resultSetImpl) {
            this.checkClosed();
            if (this.rows == null || this.rows.isEmpty()) {
                return false;
            }
            return this.index.intValue() == this.rows.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeFirst() throws SQLException {
        log.info("ResultSetImpl.beforeFirst");
        ResultSetImpl resultSetImpl = this;
        synchronized (resultSetImpl) {
            this.checkClosed();
            if (this.statement.getResultSetType() == 1003) {
                throw SqlError.createSQLException("Illegal operation for TYPE_FORWARD_ONLY ResultSet!", "S2009");
            }
            if (null == this.rows) {
                return;
            }
            this.isBeforeFirst = true;
            this.setRowPositionValidity();
            this.index = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLast() throws SQLException {
        log.info("ResultSetImpl.afterLast");
        ResultSetImpl resultSetImpl = this;
        synchronized (resultSetImpl) {
            this.checkClosed();
            if (this.statement.getResultSetType() == 1003) {
                throw SqlError.createSQLException("Illegal operation for TYPE_FORWARD_ONLY ResultSet!", "S2009");
            }
            if (null == this.rows) {
                return;
            }
            this.isAfterLast = true;
            this.setRowPositionValidity();
            this.index = this.rows.size() + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean first() throws SQLException {
        log.info("ResultSetImpl.first");
        ResultSetImpl resultSetImpl = this;
        synchronized (resultSetImpl) {
            this.checkClosed();
            if (this.statement.getResultSetType() == 1003) {
                throw SqlError.createSQLException("Illegal operation for TYPE_FORWARD_ONLY ResultSet!", "S2009");
            }
            this.setRowPositionValidity();
            this.index = 1;
            return this.onValidRow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean last() throws SQLException {
        log.info("ResultSetImpl.last");
        ResultSetImpl resultSetImpl = this;
        synchronized (resultSetImpl) {
            this.checkClosed();
            if (this.statement.getResultSetType() == 1003) {
                throw SqlError.createSQLException("Illegal operation for TYPE_FORWARD_ONLY ResultSet!", "S2009");
            }
            this.setRowPositionValidity();
            this.index = this.rows.size();
            return this.onValidRow;
        }
    }

    @Override
    public int getRow() throws SQLException {
        log.info("ResultSetImpl.getRow");
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean absolute(int row) throws SQLException {
        log.info("ResultSetImpl.absolute, row:{}", (Object)row);
        ResultSetImpl resultSetImpl = this;
        synchronized (resultSetImpl) {
            this.checkClosed();
            if (this.statement.getResultSetType() == 1003) {
                throw SqlError.createSQLException("Illegal operation for TYPE_FORWARD_ONLY ResultSet!", "S2009");
            }
            if (this.rows.size() == 0) {
                return false;
            }
            if (row > 0) {
                if (row <= this.rows.size()) {
                    this.setRowPositionValidity();
                    this.index = row;
                } else {
                    this.afterLast();
                }
            } else if (row < 0) {
                int cursor = this.rows.size() + row + 1;
                if (cursor > 0) {
                    this.setRowPositionValidity();
                    this.index = cursor;
                } else {
                    this.beforeFirst();
                }
            } else {
                this.beforeFirst();
            }
            return this.onValidRow;
        }
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        log.info("ResultSetImpl.relative, rows:{}", (Object)rows);
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        log.info("ResultSetImpl.previous");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchDirection(int direction) throws SQLException {
        log.info("ResultSetImpl.setFetchDirection, direction:{}", (Object)direction);
        ResultSetImpl resultSetImpl = this;
        synchronized (resultSetImpl) {
            ResultSetImpl.checkSupportFetchDirection(direction);
            this.fetchDirection = direction;
        }
    }

    public static void checkSupportFetchDirection(int direction) throws SQLException {
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw SqlError.createSQLException("ResultSet.Illegal_value_for_fetch_direction:" + direction, "S1009");
        }
        if (direction != 1000) {
            throw SqlError.createSQLFeatureNotSupportedException("not support fetchDirection for:" + direction, "setFetchDirection");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        return this.statement.getResultSetType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.statement.getResultSetConcurrency();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateNull");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateBoolean");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateByte");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateShort");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateInt");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateLong");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateFloat");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateDouble");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateBigDecimal");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateString");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateBytes");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateDate");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateTime");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateTimestamp");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateNull");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateBoolean");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateByte");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateShort");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateInt");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateLong");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateFloat");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateDouble");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateBigDecimal");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateString");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateBytes");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateDate");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateTime");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateTimestamp");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void insertRow() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("insertRow");
    }

    @Override
    public void updateRow() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateRow");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("deleteRow");
    }

    @Override
    public void refreshRow() throws SQLException {
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("cancelRowUpdates");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("moveToInsertRow");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        log.info("ResultSetImpl.getObject, columnIndex:{}, map:{}", (Object)columnIndex, (Object)map);
        throw SqlError.createSQLFeatureNotSupportedException("updateRef");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        log.info("ResultSetImpl.getRef, columnIndex:{}", (Object)columnIndex);
        throw SqlError.createSQLFeatureNotSupportedException("getRef");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        log.info("ResultSetImpl.getBlob");
        throw SqlError.createSQLFeatureNotSupportedException("getBlob");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        log.info("ResultSetImpl.getBlob");
        throw SqlError.createSQLFeatureNotSupportedException("getClob");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        log.info("ResultSetImpl.getArray, columnIndex:{}", (Object)columnIndex);
        throw SqlError.createSQLFeatureNotSupportedException("getArray");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        log.info("ResultSetImpl.getObject, columnLabel:{}, map:{}", (Object)columnLabel, (Object)map);
        throw SqlError.createSQLFeatureNotSupportedException("getObject");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        log.info("ResultSetImpl.getRef, columnLabel:{}", (Object)columnLabel);
        throw SqlError.createSQLFeatureNotSupportedException("getRef");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        log.info("ResultSetImpl.getBlob, columnLabel:{}", (Object)columnLabel);
        throw SqlError.createSQLFeatureNotSupportedException("getBlob");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        log.info("ResultSetImpl.getClob, columnLabel:{}", (Object)columnLabel);
        throw SqlError.createSQLFeatureNotSupportedException("getClob");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        log.info("ResultSetImpl.getArray, columnLabel:{}", (Object)columnLabel);
        throw SqlError.createSQLFeatureNotSupportedException("getArray");
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        String dateValue = this.getString(columnIndex);
        java.util.Date utilDate = this.formatUtilDate(dateValue, cal);
        return utilDate == null ? null : new Date(utilDate.getTime());
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumnIndex(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        String dateValue = this.getString(columnIndex);
        java.util.Date utilDate = this.formatUtilDate(dateValue, cal);
        return utilDate == null ? null : new Time(utilDate.getTime());
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumnIndex(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        String dateValue = this.getString(columnIndex);
        java.util.Date utilDate = this.formatUtilDate(dateValue, cal);
        return utilDate == null ? null : new Timestamp(utilDate.getTime());
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumnIndex(columnLabel), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        String val = this.getString(columnIndex);
        if (val == null) {
            return null;
        }
        try {
            return new URL(val);
        }
        catch (MalformedURLException mfe) {
            throw SqlError.createSQLException("ResultSet.Bad_format_for_URL, value:" + val, "S1009");
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumnIndex(columnLabel));
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateRef");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateRef");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateArray");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateArray");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        log.info("ResultSetImpl.getRowId, columnIndex:{}", (Object)columnIndex);
        throw SqlError.createSQLFeatureNotSupportedException("getRowId");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.getRowId(this.findColumnIndex(columnLabel));
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateRowId");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateRowId");
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.statement.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateNString");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateNString");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("getNClob");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("getNClob");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("getSQLXML");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("getSQLXML");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateSQLXML");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateSQLXML");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("getNString");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("getNString");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("getNCharacterStream");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("getNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        log.info("ResultSetImpl.getObject, columnIndex:{}, type:{}", (Object)columnIndex, (Object)type);
        if (type == null) {
            throw SqlError.createSQLException("Type parameter can not be null", "S1009");
        }
        if (type.equals(String.class)) {
            return (T)this.getString(columnIndex);
        }
        if (type.equals(BigDecimal.class)) {
            return (T)this.getBigDecimal(columnIndex);
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return (T)Boolean.valueOf(this.getBoolean(columnIndex));
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(this.getInt(columnIndex));
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return (T)Long.valueOf(this.getLong(columnIndex));
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return (T)Float.valueOf(this.getFloat(columnIndex));
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return (T)Double.valueOf(this.getDouble(columnIndex));
        }
        if (type.equals(byte[].class)) {
            return (T)this.getBytes(columnIndex);
        }
        if (type.equals(Date.class)) {
            return (T)this.getDate(columnIndex);
        }
        if (type.equals(Time.class)) {
            return (T)this.getTime(columnIndex);
        }
        if (type.equals(Timestamp.class)) {
            return (T)this.getTimestamp(columnIndex);
        }
        if (type.equals(Array.class)) {
            return (T)this.getArray(columnIndex);
        }
        if (type.equals(URL.class)) {
            return (T)this.getURL(columnIndex);
        }
        throw SqlError.createSQLException("Conversion not supported for type:" + type.getName(), "S1009");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        log.info("ResultSetImpl.getObject, columnLabel:{}, type:{}", (Object)columnLabel, (Object)type);
        return this.getObject(this.findColumnIndex(columnLabel), type);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("unwrap");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

