/*
 * Decompiled with CFR 0.152.
 */
package com.eniot.data.query.impl;

import com.eniot.data.query.EniotResultSet;
import com.eniot.data.query.exception.SqlError;
import com.eniot.data.query.util.JdbcUtils;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetMetaDataImpl
implements ResultSetMetaData {
    private static final Logger log = LoggerFactory.getLogger(ResultSetMetaDataImpl.class);
    private List<String> columns;
    private List<Integer> metaType;
    private EniotResultSet resultSet;

    public ResultSetMetaDataImpl(EniotResultSet resultSet, List<String> columns, List<Integer> metaType) {
        this.resultSet = resultSet;
        this.columns = columns;
        this.metaType = metaType;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columns == null ? 0 : this.columns.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return true;
    }

    private void checkColumnBounds(int columnIndex) throws SQLException {
        if (columnIndex < 1) {
            throw SqlError.createSQLException(String.format("Column Index out of range, %d < 1.", columnIndex), "S1009");
        }
        if (columnIndex > this.columns.size()) {
            throw SqlError.createSQLException(String.format("Column Index out of range, %d > %d.", columnIndex, this.columns.size()), "S1009");
        }
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        int columnType = this.getColumnType(column);
        switch (columnType) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        int columnType = this.getColumnType(column);
        switch (columnType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
        }
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        this.checkColumnBounds(column);
        return this.columns.get(column - 1);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumnLabel(column);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        int type = this.getColumnType(column);
        return JdbcUtils.getPrecisionFromTypes(type);
    }

    @Override
    public int getScale(int column) throws SQLException {
        int type = this.getColumnType(column);
        return JdbcUtils.getScaleFromTypes(type);
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.resultSet.getCatalog();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        this.checkColumnBounds(column);
        return this.metaType.get(column - 1);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        int columnType = this.getColumnType(column);
        return JdbcUtils.getTypeNameFromTypes(columnType);
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        int type = this.getColumnType(column);
        return JdbcUtils.getClassNameFromTypes(type);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("unwrap");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

