/*
 * Decompiled with CFR 0.152.
 */
package com.eniot.data.query.impl;

import com.eniot.data.query.EniotConnect;
import com.eniot.data.query.entity.QueryResponse;
import com.eniot.data.query.exception.SqlError;
import com.eniot.data.query.impl.ResultSetImpl;
import com.eniot.data.query.util.JdbcUtils;
import java.lang.ref.Reference;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementImpl
implements Statement {
    private static final Logger log = LoggerFactory.getLogger(StatementImpl.class);
    protected Object cancelTimeoutMutex = new Object();
    static int statementCounter = 1;
    public static final byte USES_VARIABLES_FALSE = 0;
    public static final byte USES_VARIABLES_TRUE = 1;
    public static final byte USES_VARIABLES_UNKNOWN = -1;
    protected boolean wasCancelled = false;
    protected boolean wasCancelledByTimeout = false;
    protected List<Object> batchedArgs;
    protected String charEncoding = null;
    protected volatile EniotConnect connection = null;
    protected Reference<Connection> physicalConnection = null;
    protected boolean doEscapeProcessing = true;
    private int fetchSize = 640000;
    protected boolean isClosed = false;
    protected long lastInsertId = -1L;
    private int maxFieldSize = Integer.MAX_VALUE;
    private int maxRows = 640000;
    protected boolean pedantic = false;
    protected boolean profileSQL = false;
    private int resultSetConcurrency = 0;
    private int resultSetType = 0;
    private int statementId;
    protected int timeoutInMillis = 0;
    protected long updateCount = -1L;
    protected boolean useUsageAdvisor = false;
    private SQLWarning warningChain = null;
    protected boolean clearWarningsCalled = false;
    protected boolean holdResultsOpenOverClose = false;
    protected boolean retrieveGeneratedKeys = false;
    protected boolean continueBatchOnError = false;
    protected boolean useLegacyDatetimeCode;
    protected boolean sendFractionalSeconds;
    protected boolean lastQueryIsOnDupKeyUpdate = false;
    protected final AtomicBoolean statementExecuting = new AtomicBoolean(false);
    private boolean isImplicitlyClosingResults = false;
    private volatile ResultSet results = null;
    private int fetchDirection = 1000;

    public StatementImpl(EniotConnect c, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (c == null || c.isClosed()) {
            throw SqlError.createSQLException("No operations allowed after connection closed.", "08003");
        }
        this.connection = c;
        this.statementId = statementCounter++;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        JdbcUtils.checkSql(sql);
        return this.connection.execQuerySql(this, this.connection.nativeSQL(sql));
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        log.info("StatementImpl.executeUpdate, sql:{}", (Object)sql);
        throw SqlError.createSQLFeatureNotSupportedException("executeUpdate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        log.info("StatementImpl.close");
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            this.isClosed = true;
            this.results = null;
            this.connection = null;
            this.warningChain = null;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        log.info("StatementImpl.setEscapeProcessing");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 300;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        log.info("StatementImpl.setQueryTimeout");
    }

    @Override
    public void cancel() throws SQLException {
        log.info("StatementImpl.cancel");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        log.info("StatementImpl.getWarnings");
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        log.info("StatementImpl.clearWarnings");
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        log.info("StatementImpl.setCursorName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql) throws SQLException {
        ResultSet newResults = this.executeQuery(sql);
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            this.results = newResults;
            return this.results != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getResultSet() throws SQLException {
        log.info("StatementImpl.getResultSet");
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            ResultSet res = this.results;
            this.results = null;
            return res;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        log.info("StatementImpl.getUpdateCount");
        return -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        log.info("StatementImpl.getMoreResults");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchDirection(int direction) throws SQLException {
        log.info("StatementImpl.setFetchDirection, direction:{}.", (Object)direction);
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            ResultSetImpl.checkSupportFetchDirection(direction);
            this.fetchDirection = direction;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        log.info("StatementImpl.addBatch");
        throw SqlError.createSQLFeatureNotSupportedException("addBatch");
    }

    @Override
    public void clearBatch() throws SQLException {
        log.info("StatementImpl.clearBatch");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        log.info("StatementImpl.executeBatch");
        throw SqlError.createSQLFeatureNotSupportedException("executeBatch");
    }

    @Override
    public Connection getConnection() throws SQLException {
        log.info("StatementImpl.getConnection");
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        log.info("StatementImpl.getMoreResults, current:{}", (Object)current);
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        log.info("StatementImpl.getGeneratedKeys");
        QueryResponse queryResponse = new QueryResponse();
        ArrayList<String> columns = new ArrayList<String>(4);
        columns.add("GENERATED_KEY");
        ArrayList<String> metadata = new ArrayList<String>(4);
        metadata.add("VARCHAR");
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(0);
        queryResponse.setColumns(columns);
        queryResponse.setMetadata(metadata);
        queryResponse.setRows(rows);
        return new ResultSetImpl(this.connection, this.connection.getPrivateStatement(), queryResponse);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("executeUpdate");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("executeUpdate");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("executeUpdate");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        log.info("StatementImpl.execute, sql:{}, autoGeneratedKeys:{}.", (Object)sql, (Object)autoGeneratedKeys);
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        log.info("StatementImpl.execute, sql:{}, columnIndexes:{}.", (Object)sql, (Object)columnIndexes);
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        log.info("StatementImpl.execute, sql:{}, columnNames:{}.", (Object)sql, (Object)columnNames);
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException("unwrap");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

