/*
 * Decompiled with CFR 0.152.
 */
package com.eniot.data.query.util;

import com.eniot.data.query.entity.DisallowedSqlActions;
import com.eniot.data.query.exception.SqlError;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcUtils {
    private static final Logger log = LoggerFactory.getLogger(JdbcUtils.class);

    public static void checkSql(String sql) throws SQLException {
        if (StringUtils.isBlank(sql)) {
            log.info("checkSql, sql is null");
            throw SqlError.createSQLException("sql is null!", "S1009");
        }
        for (DisallowedSqlActions action : DisallowedSqlActions.values()) {
            if (!sql.trim().toLowerCase(Locale.ENGLISH).startsWith(action.toString().toLowerCase(Locale.ENGLISH))) continue;
            log.info("checkSql, sql is illegal! Only for select sql:{}.", (Object)sql);
            throw SqlError.createSQLException("sql is illegal! Only for select sql.", "S1009");
        }
        String illegalCharacter = ";";
        if (sql.contains(illegalCharacter)) {
            log.info("checkSql, `;` is illegal char in sql:{}.", (Object)sql);
            throw SqlError.createSQLException("`;` is illegal char in sql.", "S1009");
        }
    }

    public static String fixDecimalExponent(String dString) {
        int ePos = dString.indexOf(69);
        if (ePos == -1) {
            ePos = dString.indexOf(101);
        }
        if (ePos != -1 && dString.length() > ePos + 1) {
            char maybeMinusChar = dString.charAt(ePos + 1);
            char negativeChar = '-';
            char positiveChar = '+';
            if (maybeMinusChar != negativeChar && maybeMinusChar != positiveChar) {
                StringBuilder strBuilder = new StringBuilder(dString.length() + 1);
                strBuilder.append(dString.substring(0, ePos + 1));
                strBuilder.append('+');
                strBuilder.append(dString.substring(ePos + 1, dString.length()));
                dString = strBuilder.toString();
            }
        }
        return dString;
    }

    public static int getPrecisionFromTypes(int type) {
        switch (type) {
            case -7: 
            case 16: {
                return 1;
            }
            case -6: {
                return 4;
            }
            case 5: {
                return 6;
            }
            case 4: {
                return 11;
            }
            case -5: {
                return 20;
            }
            case 6: 
            case 7: {
                return 12;
            }
            case 8: {
                return 22;
            }
            case 2: 
            case 3: {
                return 38;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 10;
            }
            case 93: {
                return 19;
            }
            case 1: {
                return 1;
            }
            case 12: {
                return 1000;
            }
            case -1: {
                return 0x2AAAAAAA;
            }
        }
        return 1000;
    }

    public static int getScaleFromTypes(int type) {
        switch (type) {
            case 6: 
            case 7: 
            case 8: {
                return 31;
            }
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 0;
            }
        }
        return 0;
    }

    public static String getTypeNameFromTypes(int type) {
        switch (type) {
            case -7: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -3: {
                return "VARBINARY";
            }
        }
        return "UNKNOWN";
    }

    public static String getClassNameFromTypes(int type) {
        switch (type) {
            case -7: 
            case 16: {
                return "java.lang.Boolean";
            }
            case -6: 
            case 5: {
                return "java.lang.Integer";
            }
            case 4: {
                return "java.lang.Integer";
            }
            case -5: {
                return "java.lang.Long";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case 7: {
                return "java.lang.Float";
            }
            case 6: 
            case 8: {
                return "java.lang.Double";
            }
            case -1: 
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case -4: 
            case -3: 
            case -2: {
                return "java.lang.String";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
        }
        return "java.lang.Object";
    }

    public static boolean isNumberType(int type) {
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }
}

