/*
 * Decompiled with CFR 0.152.
 */
package com.eniot.data.query.util;

import com.eniot.data.query.exception.SqlError;
import java.security.MessageDigest;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sha256Util {
    private static final Logger log = LoggerFactory.getLogger(Sha256Util.class);

    public static String getSHA256(String str) throws SQLException {
        String encodestr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes("UTF-8"));
            encodestr = Sha256Util.byte2Hex(messageDigest.digest());
        }
        catch (Exception e) {
            log.error("Sha256Util getSHA256 Exception", e);
            throw SqlError.createSQLException(String.format("SHA256 encode failed, msg = %s.", e.getMessage()), "S2010");
        }
        return encodestr;
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder();
        String temp = null;
        for (byte aByte : bytes) {
            temp = Integer.toHexString(aByte & 0xFF);
            if (temp.length() == 1) {
                stringBuilder.append("0");
            }
            stringBuilder.append(temp);
        }
        return stringBuilder.toString();
    }
}

