/*
 * Decompiled with CFR 0.152.
 */
package com.eniot.data.query.util;

import com.google.gson.internal.bind.util.ISO8601Utils;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeUtil {
    private static final Log logger = LogFactory.getLog(TimeUtil.class);
    public static final String DEFAULT_TIMEZONE = "GMT+08:00";
    public static final String STANDARD_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String MS_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";

    private TimeUtil() {
    }

    public static String transform(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(STANDARD_FORMAT);
        return sdf.format(date);
    }

    public static String transform(Date date, TimeZone tz) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(STANDARD_FORMAT);
        sdf.setTimeZone(tz);
        return sdf.format(date);
    }

    public static String transform(Date date, TimeZone tz, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setTimeZone(tz);
        return sdf.format(date);
    }

    public static long getMorningMillis(TimeZone tz) {
        Calendar cal = Calendar.getInstance(tz);
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static TimeZone getDefaultTimezone() {
        return TimeZone.getTimeZone(DEFAULT_TIMEZONE);
    }

    public static Long getUnixTimestampFromStandardFormat(String localTime, String timeZone) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(STANDARD_FORMAT);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
        Date date = null;
        try {
            date = simpleDateFormat.parse(localTime);
        }
        catch (ParseException e) {
            logger.error("TimeUtil.getUnixTimestampFromStandardFormat ParseException", e);
            throw new IllegalArgumentException(String.format("Invalid Arguments: %s, date format should be %s", localTime, STANDARD_FORMAT));
        }
        return date.getTime();
    }

    public static long parseISO8601ToUnixTime(String timeInISO8601) {
        try {
            Date date = ISO8601Utils.parse(timeInISO8601, new ParsePosition(0));
            return date.getTime();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(String.format("Invalid Arguments: %s date format should be yyyy-MM-ddTHH:mm:ssZ or yyyy-MM-ddTHH:mm:ss+08:00", timeInISO8601));
        }
    }

    public static String getStandardFormatFromUnixTimestamp(Long timestamp, String timeZone) {
        return TimeUtil.getFormatFromUnixTimestamp(timestamp, timeZone, STANDARD_FORMAT);
    }

    public static String getMsFormatFromUnixTimestamp(Long timestamp, String timeZone) {
        return TimeUtil.getFormatFromUnixTimestamp(timestamp, timeZone, MS_FORMAT);
    }

    private static String getFormatFromUnixTimestamp(Long timestamp, String timeZone, String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
        Date date = new Date(timestamp);
        return simpleDateFormat.format(date);
    }

    public static String getStandardFormatFromUnixTimestamp(Long timestamp) {
        return TimeUtil.getFormatFromUnixTimestamp(timestamp, DEFAULT_TIMEZONE, STANDARD_FORMAT);
    }
}

