/*
 * Decompiled with CFR 0.152.
 */
package com.envision.apim.poseidon.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.envision.apim.poseidon.config.PConfig;
import com.envision.apim.poseidon.constants.Constants;
import com.envision.apim.poseidon.core.PoseidonListener;
import com.envision.apim.poseidon.core.PoseidonReq;
import com.envision.apim.poseidon.core.PoseidonResponse;
import com.envision.apim.poseidon.exception.PoseidonException;
import com.envision.apim.poseidon.request.IPoseidonRequest;
import com.envision.apim.poseidon.util.CollectionUtils;
import com.envision.apim.poseidon.util.OkHttpUtils;
import com.envision.apim.poseidon.util.SecurityUtils;
import com.envision.apim.poseidon.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpMethod;

public final class Poseidon
implements Callback {
    private static final Map<String, String> ACCESS_TOKEN_MAPS = new ConcurrentHashMap<String, String>(1);
    private Map<String, String> gHeaders = new HashMap<String, String>(2);
    private Map<String, String> gFormParams = new HashMap<String, String>(2);
    private Map<String, String> gFormEncodeParams = new HashMap<String, String>(2);
    private Map<String, Object> gFormData = new HashMap<String, Object>(2);
    private String gRequestBody;
    private String gUrl;
    private String gMethod;
    private String filePath = "/data/file";
    private String fileName;
    private boolean isOverride;
    private PConfig pConfig;
    private PoseidonListener listener;
    private static StringBuffer sb;

    private Poseidon(PConfig pConfig) {
        this.pConfig = pConfig;
    }

    public static Poseidon config(PConfig pConfig) {
        if (StringUtils.isEmpty(pConfig.getAppKey()) || StringUtils.isEmpty(pConfig.getAppSecret())) {
            throw new PoseidonException("AppKey or AppSecret is invalid");
        }
        return new Poseidon(pConfig);
    }

    public Poseidon url(String url) {
        this.gUrl = url;
        return this;
    }

    public Poseidon method(String method) {
        this.gMethod = method;
        return this;
    }

    public Poseidon path(String path) {
        this.gUrl = this.gUrl + path;
        return this;
    }

    public Poseidon requestBody(String requestBody) {
        this.gRequestBody = requestBody;
        return this;
    }

    public Poseidon header(String k, String v) {
        this.gHeaders.put(k, v);
        return this;
    }

    public Poseidon formParam(String k, String v) {
        this.gFormParams.put(k, v);
        return this;
    }

    public Poseidon formEncodeParam(String k, String v) {
        this.gFormEncodeParams.put(k, v);
        return this;
    }

    public Poseidon formData(String k, Object v) {
        this.gFormData.put(k, v);
        return this;
    }

    public Poseidon queryParam(String k, String v) {
        if (!this.gUrl.contains("?")) {
            this.gUrl = this.gUrl + "?";
        }
        if (!this.gUrl.endsWith("&") && !this.gUrl.endsWith("?")) {
            this.gUrl = this.gUrl + "&";
        }
        this.gUrl = this.gUrl + k + "=" + v;
        return this;
    }

    public Poseidon fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Poseidon filePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    public Poseidon isOverride(boolean isOverride) {
        this.isOverride = isOverride;
        return this;
    }

    public <T> T getResponse(IPoseidonRequest baseRequest, Class<T> responseClass) throws PoseidonException {
        return JSON.parseObject(this.sync(this.parseRequestParams(baseRequest)), responseClass);
    }

    private PoseidonReq parseRequestParams(IPoseidonRequest request) {
        PoseidonReq poseidonRS = new PoseidonReq();
        poseidonRS.headers = request.headerParams().isEmpty() ? this.gHeaders : request.headerParams();
        poseidonRS.url = this.gUrl + request.baseUri();
        if (!request.pathParams().isEmpty()) {
            poseidonRS.url = this.generatePathParams(poseidonRS.url, request.pathParams());
        }
        if (!request.queryParams().isEmpty() || !request.queryEncodeParams().isEmpty()) {
            poseidonRS.url = poseidonRS.url + this.generateQueryParams(request.queryParams(), request.queryEncodeParams());
        }
        if (!request.bodyParams().isEmpty()) {
            poseidonRS.requestBody = JSON.toJSONString(request.bodyParams());
        }
        if (!StringUtils.isEmpty(request.jsonBodyString())) {
            if (poseidonRS.requestBody != null) {
                throw new PoseidonException("bodyParams and jsonBodyString not coexist");
            }
            poseidonRS.requestBody = request.jsonBodyString();
        }
        poseidonRS.method = StringUtils.isEmpty(request.method()) ? this.gMethod : request.method();
        if (!request.formParams().isEmpty()) {
            poseidonRS.formParams = request.formParams();
        }
        if (!request.formEncodeParams().isEmpty()) {
            poseidonRS.formEncodeParams = request.formEncodeParams();
        }
        poseidonRS.formData = request.formData();
        return poseidonRS;
    }

    private String generatePathParams(String uri, Map<String, Object> pathParams) {
        for (Map.Entry<String, Object> entry : pathParams.entrySet()) {
            uri = uri.replaceAll("\\{" + entry.getKey() + "\\}", entry.getValue().toString());
        }
        return uri;
    }

    private String generateQueryParams(Map<String, Object> queryParams, Map<String, Object> queryEncodeParams) {
        StringBuilder urlBuilder = new StringBuilder();
        for (Map.Entry<String, Object> entry : queryParams.entrySet()) {
            if (entry.getValue() == null) continue;
            urlBuilder.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        if (queryEncodeParams != null) {
            for (Map.Entry<String, Object> entry : queryEncodeParams.entrySet()) {
                if (entry.getValue() == null) continue;
                try {
                    urlBuilder.append(entry.getKey()).append("=").append(URLEncoder.encode(String.valueOf(entry.getValue()), "UTF-8")).append("&");
                }
                catch (UnsupportedEncodingException e) {
                    throw new PoseidonException(e);
                }
            }
        }
        if (urlBuilder.length() > 0) {
            urlBuilder.deleteCharAt(urlBuilder.lastIndexOf("&"));
            return "?" + urlBuilder.toString();
        }
        return "";
    }

    public String sync() throws PoseidonException {
        return this.sync(new PoseidonReq(this.gUrl, this.gMethod, this.gRequestBody, this.gFormParams, this.gFormEncodeParams, this.gHeaders, this.gFormData));
    }

    private boolean processRequestFile(Response response) throws IOException {
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            throw new PoseidonException("response body is null");
        }
        boolean isStream = Poseidon.isStreamType(response);
        if (isStream) {
            if (StringUtils.isEmpty(this.fileName)) {
                this.fileName = OkHttpUtils.getFileNameByContentDisPosition(response.header("Content-Disposition"));
            }
            if (!this.filePath.endsWith(File.separator)) {
                this.filePath = this.filePath + File.separator;
            }
            Files.createDirectories(Paths.get(this.filePath, new String[0]), new FileAttribute[0]);
            Path path = Paths.get(this.filePath + this.fileName, new String[0]);
            File file = path.toFile();
            if (this.isOverride && file.exists()) {
                Files.copy(responseBody.byteStream(), path, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.copy(responseBody.byteStream(), path, new CopyOption[0]);
            }
            this.showInfo("FileSavePath: " + file.getAbsolutePath());
            return true;
        }
        return false;
    }

    public PoseidonResponse request() {
        PoseidonReq req = new PoseidonReq(this.gUrl, this.gMethod, this.gRequestBody, this.gFormParams, this.gFormEncodeParams, this.gHeaders, this.gFormData);
        Response response = null;
        try {
            JSONObject body;
            response = this.request(req, this.createAccessToken(), null);
            if (response == null) {
                throw new PoseidonException("response is null");
            }
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                throw new PoseidonException("response body is null");
            }
            boolean isStream = Poseidon.isStreamType(response);
            if (isStream) {
                return new PoseidonResponse(response);
            }
            String bodyStr = this.processResponseBody(response);
            ResponseBody responseBodyNew = ResponseBody.create(null, bodyStr);
            try {
                body = JSONObject.parseObject(bodyStr);
            }
            catch (Exception e) {
                return new PoseidonResponse(response, responseBodyNew);
            }
            if (body == null || body.isEmpty()) {
                return new PoseidonResponse(response);
            }
            String at = this.resetAt(body);
            if (at != null) {
                this.showInfo("access token expire repeat request...");
                response = this.request(req, at, null);
                return new PoseidonResponse(response);
            }
            return new PoseidonResponse(response, responseBodyNew);
        }
        catch (Exception e) {
            throw new PoseidonException(e, new PoseidonResponse(response, e.getMessage()));
        }
    }

    private String resetAt(JSONObject body) {
        String at = null;
        Integer status = body.getInteger("apim_status");
        if (Constants.EXPIRE_ACCESS_TOKEN_TIMEOUT_CODE.equals(status)) {
            at = this.createAccessToken(body.getString("apim_refreshtoken"));
        } else if (Constants.EXPIRE_REFRESH_TOKEN_TIMEOUT_CODE.equals(status)) {
            ACCESS_TOKEN_MAPS.remove(this.pConfig.getAppKey() + this.pConfig.getAppSecret());
            at = this.createAccessToken();
        }
        return at;
    }

    public String sync(PoseidonReq req) throws PoseidonException {
        String bodyStr;
        Response response = null;
        try {
            response = this.request(req, this.createAccessToken(), null);
            bodyStr = this.processResponseBody(response);
            bodyStr = this.resetAccessToken(req, bodyStr);
        }
        catch (Exception e) {
            ACCESS_TOKEN_MAPS.remove(this.pConfig.getAppKey() + this.pConfig.getAppSecret());
            throw new PoseidonException(e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (Exception exception) {}
        }
        return bodyStr;
    }

    public static boolean isStreamType(Response response) {
        String contentDisposition = response.header("Content-Disposition");
        MediaType mediaType = response.body().contentType();
        String subtype = mediaType != null ? mediaType.subtype() : null;
        return OkHttpUtils.isStream(contentDisposition, subtype);
    }

    public void async(PoseidonListener listener) throws PoseidonException {
        try {
            this.request(new PoseidonReq(this.gUrl, this.gMethod, this.gRequestBody, this.gFormParams, this.gFormEncodeParams, this.gHeaders, this.gFormData), this.createAccessToken(), listener);
        }
        catch (IOException e) {
            throw new PoseidonException(e);
        }
    }

    private String resetAccessToken(PoseidonReq req, String bodyStr) throws IOException {
        JSONObject body;
        try {
            body = JSONObject.parseObject(bodyStr);
        }
        catch (Exception e) {
            return bodyStr;
        }
        if (body == null || body.isEmpty()) {
            return bodyStr;
        }
        String at = this.resetAt(body);
        if (at != null) {
            this.showInfo("access token expire repeat request...");
            Response response = this.request(req, at, null);
            bodyStr = this.processResponseBody(response);
            this.showInfo("responseBody: " + bodyStr);
        }
        return bodyStr;
    }

    private String createAccessToken() {
        String act = ACCESS_TOKEN_MAPS.get(this.pConfig.getAppKey() + this.pConfig.getAppSecret());
        if (act != null) {
            this.showInfo("use already exist accessToken:" + act);
            return act;
        }
        String rt = SecurityUtils.createToken(SecurityUtils.pin(this.pConfig), Constants.EXPIRE_REFRESH_TOKEN);
        return this.createAccessToken(rt);
    }

    private String createAccessToken(String rt) {
        String pin = SecurityUtils.pin(this.pConfig);
        String at = SecurityUtils.createToken(pin, Constants.EXPIRE_ACCESS_TOKEN);
        ACCESS_TOKEN_MAPS.put(this.pConfig.getAppKey() + this.pConfig.getAppSecret(), at);
        return SecurityUtils.accessToken(pin, this.pConfig.getAppKey(), this.pConfig.getAppSecret(), at, rt);
    }

    private Call getCall(PoseidonReq req, String accessToken) {
        Object builder;
        RequestBody body = null;
        if (!StringUtils.isEmpty(req.requestBody)) {
            this.showInfo("requestBody: " + req.requestBody);
            body = RequestBody.create(MediaType.parse("application/json;charset=utf-8"), req.requestBody);
        }
        if (CollectionUtils.isEmpty(req.headers)) {
            req.headers = new HashMap<String, String>(1);
        }
        if (!CollectionUtils.isEmpty(req.formParams) || !CollectionUtils.isEmpty(req.formEncodeParams)) {
            if (body != null) {
                throw new PoseidonException("formParams and jsonBody not coexist");
            }
            builder = new FormBody.Builder();
            if (!CollectionUtils.isEmpty(req.formParams)) {
                for (Map.Entry<String, String> entry : req.formParams.entrySet()) {
                    ((FormBody.Builder)builder).addEncoded(entry.getKey(), entry.getValue());
                }
            }
            if (!CollectionUtils.isEmpty(req.formEncodeParams)) {
                for (Map.Entry<String, String> entry : req.formEncodeParams.entrySet()) {
                    ((FormBody.Builder)builder).add(entry.getKey(), entry.getValue());
                }
            }
            body = ((FormBody.Builder)builder).build();
            if (this.pConfig.isDebug()) {
                StringBuilder sb = new StringBuilder();
                FormBody formBody = (FormBody)body;
                for (int i = 0; i < formBody.size(); ++i) {
                    sb.append(formBody.encodedName(i)).append("=").append(formBody.encodedValue(i)).append(";");
                }
                Poseidon.debug("formParam: " + sb.toString());
            }
        }
        if (!CollectionUtils.isEmpty(req.formData)) {
            this.showInfo("formData: " + req.formData);
            if (body != null) {
                throw new PoseidonException("FormParams or JsonBody and FormData not coexist");
            }
            req.isFormData = true;
        }
        if (body == null && HttpMethod.requiresRequestBody(req.method)) {
            body = RequestBody.create(MediaType.parse("application/json;charset=utf-8"), "{}");
        }
        builder = new Request.Builder().url(req.url).method(req.method, body);
        if (accessToken != null) {
            ((Request.Builder)builder).addHeader("apim-accesstoken", accessToken);
        }
        for (Map.Entry entry : req.headers.entrySet()) {
            ((Request.Builder)builder).addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        Request request = ((Request.Builder)builder).build();
        this.showInfo("headers: " + Poseidon.getResponseHeaders(request.headers(), null));
        return OkHttpUtils.getInstance().getHttpClient(this.pConfig, req).newCall(request);
    }

    public Response request(PoseidonReq req, String accessToken, PoseidonListener listener) throws IOException {
        if (StringUtils.isEmpty(req.url) || StringUtils.isEmpty(req.method)) {
            throw new PoseidonException("Url or Method is invalid");
        }
        this.showInfo("url: " + req.url);
        this.showInfo("method: " + req.method);
        Call call = this.getCall(req, accessToken);
        if (listener == null) {
            return call.execute();
        }
        this.listener = listener;
        call.enqueue(this);
        return null;
    }

    public static void debug(String info) {
        try {
            sb.setLength(0);
            sb.append(DateFormat.getDateTimeInstance().format(new Date())).append(" [Poseidon] ").append(info).append("\n");
            System.out.write(sb.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new PoseidonException(e);
        }
    }

    public void showInfo(String info) {
        if (this.pConfig.isDebug()) {
            Poseidon.debug(info);
        }
    }

    @Override
    public void onFailure(Call call, IOException e) {
        this.showInfo(e.getMessage());
        if (this.listener == null) {
            return;
        }
        this.listener.onFailure(e.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResponse(Call call, Response response) throws IOException {
        if (this.listener == null) {
            return;
        }
        String bodyStr = this.processResponseBody(response);
        try {
            bodyStr = this.resetAccessToken(new PoseidonReq(this.gUrl, this.gMethod, this.gRequestBody, this.gFormParams, this.gFormEncodeParams, this.gHeaders, this.gFormData), bodyStr);
        }
        finally {
            try {
                response.close();
            }
            catch (Exception exception) {}
        }
        this.listener.onResponse(bodyStr);
    }

    private String processResponseBody(Response response) throws IOException {
        String bodyStr;
        if (response == null) {
            throw new PoseidonException("response is null");
        }
        this.showInfo("httpStatus: " + response.code());
        this.showInfo("responseHeaders: " + Poseidon.getResponseHeaders(response.headers(), null));
        if (this.processRequestFile(response)) {
            return "SUCCESS";
        }
        String string = bodyStr = response.body() != null ? response.body().string() : null;
        if (!response.isSuccessful()) {
            throw new PoseidonException(bodyStr != null ? bodyStr : response.message());
        }
        this.showInfo("responseBody: " + bodyStr);
        return bodyStr;
    }

    public static String getResponseHeaders(Headers headers, String prefix) {
        if (headers == null) {
            return "";
        }
        Set<String> names = headers.names();
        if (names.isEmpty()) {
            return "";
        }
        StringBuilder sbd = new StringBuilder();
        for (String key : names) {
            if (prefix != null && !key.startsWith(prefix)) continue;
            sbd.append(key).append("=").append(headers.values(key)).append(",");
        }
        if (sbd.length() > 0) {
            sbd.deleteCharAt(sbd.length() - 1);
        }
        return sbd.toString();
    }

    static {
        JSON.DEFAULT_PARSER_FEATURE &= ~Feature.UseBigDecimal.getMask();
        sb = new StringBuffer();
    }
}

