/*
 * Decompiled with CFR 0.152.
 */
package com.envision.apim.poseidon.interceptor;

import com.alibaba.fastjson.JSON;
import com.envision.apim.poseidon.core.PoseidonReq;
import com.envision.apim.poseidon.interceptor.BaseInterceptor;
import java.io.File;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class UploadInterceptor
extends BaseInterceptor {
    private PoseidonReq poseidonReq;

    public UploadInterceptor(PoseidonReq poseidonReq) {
        this.poseidonReq = poseidonReq;
    }

    @Override
    protected Response processAfter(Response response) {
        return response;
    }

    @Override
    protected void processBefore(Request request, Request.Builder newBuilder) {
        if (this.poseidonReq != null && this.poseidonReq.isFormData()) {
            MultipartBody.Builder builder = new MultipartBody.Builder();
            builder.setType(MultipartBody.FORM);
            for (Map.Entry<String, Object> entry : this.poseidonReq.getFormData().entrySet()) {
                Object value = entry.getValue();
                if (value instanceof File) {
                    File file = (File)value;
                    String fileName = file.getName();
                    builder.addFormDataPart(entry.getKey(), fileName, RequestBody.create(null, file));
                    continue;
                }
                if (value instanceof String) {
                    builder.addFormDataPart(entry.getKey(), null, RequestBody.create(null, value.toString()));
                    continue;
                }
                builder.addFormDataPart(entry.getKey(), null, RequestBody.create(MediaType.parse("application/json;charset=utf-8"), JSON.toJSONString(value)));
            }
            newBuilder.method(request.method(), builder.build());
        }
    }
}

