/*
 * Decompiled with CFR 0.152.
 */
package com.envision.apim.poseidon.util;

import com.envision.apim.poseidon.config.PConfig;
import com.envision.apim.poseidon.core.PoseidonReq;
import com.envision.apim.poseidon.expand.ProxyAuthenticator;
import com.envision.apim.poseidon.interceptor.ApimInterceptor;
import com.envision.apim.poseidon.interceptor.UploadInterceptor;
import com.envision.apim.poseidon.util.StringUtils;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;

public class OkHttpUtils {
    private static volatile OkHttpUtils okHttpUtils;
    private ConcurrentHashMap<String, OkHttpClient> httpClientMap = new ConcurrentHashMap(1);
    private static X509TrustManager x509TrustManager;

    private static TrustManager[] getTrustManager() {
        x509TrustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        TrustManager[] trustAllCerts = new TrustManager[]{x509TrustManager};
        return trustAllCerts;
    }

    public static SSLSocketFactory getSSLSocketFactory() {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, OkHttpUtils.getTrustManager(), new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static HostnameVerifier getHostnameVerifier() {
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        };
        return hostnameVerifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpUtils getInstance() {
        if (okHttpUtils != null) return okHttpUtils;
        Class<OkHttpUtils> clazz = OkHttpUtils.class;
        synchronized (OkHttpUtils.class) {
            if (okHttpUtils != null) return okHttpUtils;
            okHttpUtils = new OkHttpUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return okHttpUtils;
        }
    }

    public OkHttpClient getHttpClient(PConfig pConfig, PoseidonReq poseidonReq) {
        String key = pConfig.getMapKey();
        if (!poseidonReq.isFormData() && this.httpClientMap.containsKey(key)) {
            return this.httpClientMap.get(key);
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        PConfig.ProxyConfig proxyConfig = pConfig.getProxyConfig();
        if (proxyConfig != null) {
            builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyConfig.getIp(), (int)proxyConfig.getPort())));
            String userName = proxyConfig.getUserName();
            String password = proxyConfig.getPassword();
            builder.proxyAuthenticator(new ProxyAuthenticator(userName, password));
        }
        if (!pConfig.isVerifySSL()) {
            builder.sslSocketFactory(OkHttpUtils.getSSLSocketFactory(), x509TrustManager).hostnameVerifier(OkHttpUtils.getHostnameVerifier());
        }
        builder.followRedirects(false);
        if (!poseidonReq.isFormData()) {
            builder.addInterceptor(new ApimInterceptor());
        } else {
            builder.addInterceptor(new UploadInterceptor(poseidonReq));
        }
        OkHttpClient client = builder.connectTimeout(pConfig.getConnectTimeout(), TimeUnit.MILLISECONDS).writeTimeout(pConfig.getWriteTimeout(), TimeUnit.MILLISECONDS).readTimeout(pConfig.getReadTimeout(), TimeUnit.MILLISECONDS).build();
        if (!poseidonReq.isFormData()) {
            this.httpClientMap.put(key, client);
        }
        return client;
    }

    public static String getFileNameByContentDisPosition(String contentDisposition) {
        String filename = System.currentTimeMillis() + "";
        if (StringUtils.isEmpty(contentDisposition)) {
            return filename;
        }
        for (String s : contentDisposition.split(";")) {
            if (!s.startsWith("filename")) continue;
            filename = s.substring(s.indexOf("=") + 1);
            break;
        }
        return filename;
    }

    public static boolean isStream(String contentDisposition, String subtype) {
        return contentDisposition != null || "octet-stream".equals(subtype);
    }
}

