package com.envisioniot.enos.alert_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.alert_service.vo.AlertVo;
import com.envisioniot.enos.event_service.vo.ActiveAlert;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author haifeng.zhu
 * @date 2021/3/15
 */

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class BatchCreateAlertsRequest  extends PoseidonRequest {
    private String orgId;
    private List<AlertVo> alertVoList;

    @Override
    public Map<String, Object> queryParams() {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "batchCreate");
        params.put("orgId", orgId);
        return params;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String,Object> params = new HashMap<>();
        if(alertVoList != null){
            params.put("alertVoList",alertVoList);
        }
        return params;
    }

    @Override
    public String baseUri() {
        return "/alert-service/v2.1/alerts";
    }

    @Override
    public String method() {
        return  "POST";
    }
}
