package com.envisioniot.enos.alert_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author by tao.wu
 * @date 2019/7/4 16:54
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class BatchUpdateAlertTagsRequest extends PoseidonRequest {

    private String orgId;
    private List<String> alertIds;
    private Map<String, String> tags;
    private Boolean isPatchUpdate;

    @Override
    public Map<String, Object> queryParams() {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "batchUpdateTags");
        params.put("orgId", orgId);
        if(isPatchUpdate != null){
            params.put("isPatchUpdate",isPatchUpdate);
        }
        return params;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "batchUpdateTags");

        if(alertIds != null){
            params.put("alertIds",alertIds);
        }
        if(tags != null){
            params.put("tags",tags);
        }

        return params;
    }

    @Override
    public String baseUri() {
        return "/alert-service/v2.1/alerts";
    }

    @Override
    public String method() {
        return  "POST";
    }
}
