package com.envisioniot.enos.alert_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.alert_service.vo.AlertVo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * @author haifeng.zhu
 * @date 2021/3/12
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class CreateAlertRequest  extends PoseidonRequest {
    private String orgId;
    private AlertVo alertVo;


    @Override
    public Map<String, Object> queryParams() {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "create");
        params.put("orgId", orgId);
        return params;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String,Object> params = new HashMap<>();
        if(alertVo != null){
            params.put("alertVo",alertVo);
        }
        return params;
    }

    @Override
    public String baseUri() {
        return "/alert-service/v2.1/alerts";
    }

    @Override
    public String method() {
        return  "POST";
    }
}
