package com.envisioniot.enos.alert_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.api.common.constant.request.Pagination;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class SearchAlertRequest extends PoseidonRequest {

    private String orgId;
    private String instanceId;
    private String metricId;
    private String startOccurTime;
    private String endOccurTime;
    private String startRecoverTime;
    private String endRecoverTime;
    private Boolean active;
    private String expression;
    private Pagination pagination;

    @Override
    public Map<String, Object> queryParams() {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "search");
        params.put("orgId", orgId);
        return params;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "search");
        if(instanceId != null){
            params.put("instanceId",instanceId);
        }
        if(metricId != null){
            params.put("metricId",metricId);
        }
        if(startOccurTime != null){
            params.put("startOccurTime",startOccurTime);
        }
        if(endOccurTime != null){
            params.put("endOccurTime",endOccurTime);
        }
        if(startRecoverTime != null){
            params.put("startRecoverTime",startRecoverTime);
        }
        if(endRecoverTime != null){
            params.put("endRecoverTime",endRecoverTime);
        }
        if(expression != null){
            params.put("expression",expression);
        }
        if (pagination != null) {
            params.put("pagination", pagination);
        }
        if (active != null) {
            params.put("active", active);
        }
        return params;
    }

    @Override
    public String baseUri() {
        return "/alert-service/v2.1/alerts";
    }

    @Override
    public String method() {
        return  "POST";
    }
}
