package com.envisioniot.enos.alert_service.v2_4;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.alert_service.vo.AlertRule;
import java.util.HashMap;
import java.util.Map;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class CreateAlertRuleRequest extends PoseidonRequest {
    private AlertRule alertRule;
    private String orgId;


    @Override
    public Map<String, Object> queryParams() {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "create");
        params.put("orgId", orgId);
        return params;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String,Object> params = new HashMap<>();
        if(alertRule != null){
            params.put("alertRule",alertRule);
        }
        return params;
    }

    @Override
    public String baseUri() {
        return "/alert-service/v2.4/alert-rules";
    }

    @Override
    public String method() {
        return  "POST";
    }
}
