package com.envisioniot.enos.alert_service.v2_4;

import com.envision.apim.poseidon.request.PoseidonRequest;
import java.util.HashMap;
import java.util.Map;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class DeleteAlertRuleRequest extends PoseidonRequest {
    private String orgId;
    private String ruleId;
    private String source;


    @Override
    public Map<String, Object> queryParams() {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "delete");
        params.put("orgId", orgId);
        return params;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String,Object> params = new HashMap<>();
        if(ruleId != null){
            params.put("ruleId",ruleId);
        }
        if(source != null){
            params.put("source",source);
        }
        return params;
    }

    @Override
    public String baseUri() {
        return "/alert-service/v2.4/alert-rules";
    }

    @Override
    public String method() {
        return  "POST";
    }
}
