package com.envisioniot.enos.alert_service.v2_4;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.api.common.constant.request.Pagination;
import java.util.HashMap;
import java.util.Map;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class SearchAlertRuleRequest extends PoseidonRequest {
    private String orgId;
    private String expression;
    private Pagination pagination;


    @Override
    public Map<String, Object> queryParams() {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "search");
        params.put("orgId", orgId);
        return params;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String,Object> params = new HashMap<>();
        if(expression != null){
            params.put("expression",expression);
        }
        if(pagination != null){
            params.put("pagination",pagination);
        }
        return params;
    }

    @Override
    public String baseUri() {
        return "/alert-service/v2.4/alert-rules";
    }

    @Override
    public String method() {
        return  "POST";
    }
}
