package com.envisioniot.enos.alert_service.vo;

import com.envisioniot.enos.alert_service.vo.condition.AlertCondition;
import com.envisioniot.enos.alert_service.vo.condition.selector.AlertSelector;
import com.envisioniot.enos.api.common.constant.common.StringI18n;
import java.util.Map;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;


@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class AlertRule {
    
    // 必填
    private String ruleId;
    // 必填
    private String orgId;
    // 非必填
    private StringI18n ruleName;
    // 非必填
    private StringI18n ruleDesc;
    // 必填
    private String alertSeverityId;
    // 必填
    private String alertTypeId;
    
    private String parentAlertTypeId;
    
    private StringI18n alertContent;
    /**
     * 0：Discrete alert, 1：Continuous alert.告警记录均存储
     */
    // 非必填 默认 Continuous todo：String
    private String continuity;
    // 非必填 默认true
    private Boolean enabled = true;
    // 必填
    private AlertCondition alertCondition;
    
    private AlertSelector alertSelector;
    
    /**
     * metric timeout, 用于多测点告警，单测点可不填
     * -1就相当于没传, 表示测点永不失效
     * 单位 ms, [60, 86400]
     */
    private Integer metricTimeout;
    // 非必填
    private Integer delayTime;
    
    private String source;
    
    private String app;
    
    private Map<String, String> labels;
    // 非必填
    private Map<String, String> tags;
    
}
