package com.envisioniot.enos.alert_service.vo;

import com.envisioniot.enos.api.common.constant.common.StringI18n;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Tolerate;

import java.util.Map;

/**
 * 这个类是alert-engine对外暴露的格式。主要是用于接口和订阅
 * @author haifeng.zhu
 * @date 2020/11/4
 */
@Getter
@Setter
public class AlertVo {
    /**
     * Alert的唯一识别号
     */
    private String alertId;
    /**
     * 0：告警引擎产生的告警解除
     *
     * 1：告警引擎产生的告警
     *
     * 2：接口创建的恢复
     *
     * 3：接口创建的开始
     *
     * 4：离散
     *
     * 5: 乱序
     */
    private Integer eventType;
    /**
     * OU ID
     */
    private String orgId;
    /**
     * 告警的实体，现阶段只有asset，取值为assetId
     */
    private String instanceId;
    /**
     * metric，如测点
     */
    private String metricId;
    /**
     * 告警发生的时间, Unix时间戳
     */
    private Long occurTime;
    /**
     * 告警发生的本地时间
     *
     * 当metric中带有timezone时会计算本地时间，如果metric不带，默认为UTC零时区
     */
    private String localOccurTime;
    /**
     * 告警恢复的时间 Unix时间戳
     */
    private Long recoverTime;
    /**
     * 告警恢复的本地时间
     */
    private String localRecoverTime;
    /**
     * 异常状况恢复的原因
     */
    private String recoverReason;
    /**
     * 告警产生时的metric value
     * 对于高级的告警功能比如多测点告警或者时序告警，使用的是产生告警对应的那个metric的value
     */
    private String value;
    /**
     * 告警产生时的metric value
     * 对于高级的告警功能比如多测点告警或者时序告警，使用的是产生告警对应的那个metric的labels
     */
    private Map<String, String> metricTags;
    private String severityId;
    private StringI18n severityDesc;
    private String typeId;
    private StringI18n typeDesc;
    private String parentTypeId;
    private StringI18n parentTypeDesc;
    private StringI18n content;
    private String ruleId;
    private StringI18n ruleDesc;
    private Map<String, String> ruleTags;
    private Map<String, String> tags;
    private Boolean inhibited;
    @Tolerate
    public AlertVo() {
    }
}
