package com.envisioniot.enos.alert_service.vo.condition;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * @author jie.qin
 * @date 2020/10/21
 */
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class AlertTimeSeriesCondition implements Serializable {

    private static final long serialVersionUID = -5863105751378427888L;

    public final static String WINDOW_TYPE_SLIDING = "SLIDING";
    public final static String WINDOW_TYPE_TUMBLING = "TUMBLING";

    public final static String OPERATOR_EQ = "EQ";
    public final static String OPERATOR_GT = "GT";
    public final static String OPERATOR_LT = "LT";

    public final static String WINDOW_UNIT_MINUTE = "m";
    

    /**
     * 窗口类型：SLIDING TUMBLING
     */
    private String windowType;

    /**
     * 方法 可选值:  CHANGELESS NODATA COUNT
     */
    private String method;

    /**
     * 窗口时间 单位：秒
     */
    private Integer windowSize;

    /**
     * 操作符 可选值： EQ  GT  LT
     */
    private String operator = OPERATOR_EQ;

    /**
     * 人工编写的时序告警条件表达式，editMode="MANUAL"时有值（该字段仅存在数据库中，不用于前后端交互）
     * expression中不包含triggerId、alias
     * e.g. COUNT(${rate}) > 10
     */
    private String manualExpression;
    
    private Object value = 0;





}
