package com.envisioniot.enos.alert_service.vo.condition.selector;

import com.envisioniot.enos.alert_service.vo.AlertMetricVO;
import com.envisioniot.enos.alert_service.vo.TreeNode;
import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class EnosMetricSelector implements Serializable {

	/**
	 *  触发器id
	 */
	String selectorId;
	
	/**
	 * 在告警触发条件时用到，event, status, model_measurepoint
	 */
	String dataSource;
	
	/**
	 *  模型id
	 */
	public String modelId;
	
	/**
	 *  测点id
	 */
	private List<AlertMetricVO> metrics;
	
	/**
	 *  资产作用范围
	 */
	public List<String> assetScope;
	
	/**
	 *  资产树作用范围
	 */
	public List<TreeNode> assetTreeScope;
}
