package com.envisioniot.enos.alert_service.vo.condition.selector;


import com.envisioniot.enos.alert_service.vo.AlertMetricVO;
import com.envisioniot.enos.alert_service.vo.TreeNode;
import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;


@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class KPIMetricSelector implements Serializable {
	
	/**
	 *  触发器id
	 */
	String selectorId;
	
	/**
	 *  metrics 的值需要是唯一的。并且用户在上传的测点中，需要包含这个值
	 */
	List<AlertMetricVO> metrics;
	
	/**
	 *  资产作用范围
	 */
	public List<String> assetScope;
	
	/**
	 *  资产树作用范围
	 */
	public List<TreeNode> assetTreeScope;
	
}
