package com.envisioniot.enos.asset_tree_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.asset_tree_service.vo.AssetIdentifierVo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author youwen.wang
 * @date 2022/3/8 2:53 下午
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class AssociateAssetNodeBatchRequest extends PoseidonRequest {

    private String orgId;
    private String treeId;
    private String parentAssetId;
    private List<AssetIdentifierVo> assetIdentifiers;

    @Override
    public String baseUri()
    {
        return "/asset-tree-service/v2.1/asset-nodes";
    }

    @Override
    public String method()
    {
        return "POST";
    }

    @Override
    public Map<String, Object> queryParams()
    {
        Map<String, Object> params = new HashMap<>();
        params.put("action", "associateAssetBatch");
        params.put("orgId", orgId);
        params.put("treeId", treeId);
        params.put("parentAssetId", parentAssetId);
        return params;
    }

    @Override
    public Map<String, Object> bodyParams()
    {
        Map<String, Object> params = new HashMap<>();
        params.put("assetIdentifiers", assetIdentifiers);
        return params;
    }
}
