package com.envisioniot.enos.asset_tree_service.v2_1;

import java.util.HashMap;
import java.util.Map;

import com.envision.apim.poseidon.request.PoseidonRequest;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class DeleteAssetNodeRequest extends PoseidonRequest
{
    private String orgId;
    private String treeId;

    private String assetId;
    private String productKey;
    private String deviceKey;

    private Boolean force;

    @Override
    public String baseUri()
    {
        return "/asset-tree-service/v2.1/asset-nodes";
    }

    @Override
    public String method()
    {
        return "POST";
    }

    @Override
    public Map<String, Object> queryParams()
    {
        Map<String, Object> params = new HashMap<>();
        params.put("action", "delete");
        params.put("orgId", orgId);
        params.put("treeId", treeId);
        if (assetId != null)
        {
            params.put("assetId", assetId);
        }
        if (productKey != null)
        {
            params.put("productKey", productKey);
        }
        if (deviceKey != null)
        {
            params.put("deviceKey", deviceKey);
        }
        if (force != null)
        {
            params.put("force", force);
        }
        return params;

    }

}
