package com.envisioniot.enos.asset_tree_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.asset_tree_service.vo.AssetIdentifierVo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author youwen.wang
 * @date 2022/5/24 11:22 下午
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class MoveAssetNodeRequest extends PoseidonRequest {

    private String orgId;
    private String treeId;
    private String parentAssetId;
    private String preAssetId;
    private String assetId;


    @Override
    public String baseUri()
    {
        return "/asset-tree-service/v2.1/asset-nodes";
    }

    @Override
    public String method()
    {
        return "POST";
    }

    @Override
    public Map<String, Object> queryParams()
    {
        Map<String, Object> params = new HashMap<>();
        params.put("action", "move");
        params.put("orgId", orgId);
        params.put("treeId", treeId);
        params.put("parentAssetId", parentAssetId);
        params.put("preAssetId", preAssetId);
        params.put("assetId", assetId);

        return params;
    }


}
