package com.envisioniot.enos.connect_service.v2_1.cert;

import com.envision.apim.poseidon.request.PoseidonRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * @author qiwei.tan
 * @version 1.0
 * @program enos-commons-parent
 * @ClassName AbstractCertificateRequest
 * @Description 抽象证书请求类
 * @date 2019/12/2 15:53
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
abstract class AbstractCertificateRequest extends PoseidonRequest {
    @Getter
    private static final String BASE_URI = "/connect-service/v2.0/certificates";
    protected String orgId;
    protected String assetId;
    protected String productKey;
    protected String deviceKey;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> map = new HashMap<>();
        map.put("action", action());
        if (orgId != null) {
            map.put("orgId", orgId);
        }
        if (assetId != null) {
            map.put("assetId", assetId);
        }
        if (deviceKey != null) {
            map.put("deviceKey", deviceKey);
        }
        if (productKey != null) {
            map.put("productKey", productKey);
        }
        return map;
    }

    @Override
    public String method() {
        return "POST";
    }

    @Override
    public String baseUri() {
        return BASE_URI;
    }

    /**
     * return action name
     *
     * @return action name
     */
    protected abstract String action();
}
