package com.envisioniot.enos.connect_service.v2_1.cert;

import com.google.common.collect.Maps;
import lombok.*;

import java.util.HashMap;
import java.util.Map;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
public class RevokeCertificateRequest extends AbstractCertificateRequest {
    private Integer certSn;
    private Integer reason = RevokeReason.UNSPECIFIED;

    @Override
    public Map<String, Object> bodyParams() {
        Map<String, Object> map = Maps.newHashMap();
        if (certSn != null) {
            map.put("certSn", certSn);
        }
        if (reason != null) {
            map.put("reason", reason);
        }
        return map;
    }

    @Override
    protected String action() {
        return "revoke";
    }
}