package com.envisioniot.enos.connect_service.v2_1.connection_topos;

import com.envisioniot.enos.api.common.constant.request.Pagination;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * @author mengyuantan
 * @date 2021/1/25 23:01
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class GetChildNodesRequest extends AbstractTopoRequest {

    private String orgId;
    private String rootAssetId;
    private String nodeId;
    private Pagination pagination;

    @Override
    public Map<String, Object> queryParams() {
        final Map<String, Object> map = new HashMap<>(2);
        map.put("action", action());
        map.put("orgId", orgId);
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        final Map<String, Object> map = new HashMap<>(4);
        map.put("action", action());
        if (rootAssetId != null) {
            map.put("rootAssetId", rootAssetId);
        }
        if (nodeId != null) {
            map.put("nodeId", nodeId);
        }
        if (pagination != null) {
            map.put("pagination", pagination);
        }
        return map;
    }

    @Override
    protected String action() {
        return "getChildNodes";
    }
}
