package com.envisioniot.enos.connect_service.v2_1.connection_topos;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * @author mengyuantan
 * @date 2021/1/25 23:14
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class GetRootNodesRequest extends AbstractTopoRequest {

    private String orgId;

    @Override
    public Map<String, Object> queryParams() {
        final Map<String, Object> map = new HashMap<>(2);
        map.put("action", action());
        map.put("orgId", orgId);
        return map;
    }

    @Override
    public String method() {
        return "GET";
    }

    @Override
    protected String action() {
        return "getRootNodes";
    }
}
