package com.envisioniot.enos.connect_service.v2_1.connection_topos.vo;

import com.envisioniot.enos.api.common.constant.common.StringI18n;
import lombok.Data;

import javax.annotation.Nullable;


@Data
public class NodeChangeVo {
    private String ou;

    /**
     * 用于唯一识别一个拓扑连接
     */
    private String rootAssetId;

    /**
     * 由节点名称构成（主要是为了方便用户理解），比如/Extensive1/Edge1/connection1/dev1。
     * 对于虚拟节点，如果名称没有提供，则采用nodeId。
     */
    private String nodePath;

    private String nodeId;

    /**
     * 只有设备节点才有这个信息，虚拟节点没有
     */
    @Nullable
    private String assetId;

    /**
     * 这里只保存edge上报的原始节点名称
     */
    private StringI18n name;

    private int state;
    private long reportTime;

    /**
     * 节点上报的额外信息，比如节点变为离线的原因
     */
    private String info;
}
