package com.envisioniot.enos.connect_service.v2_1.device;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * Desc:
 *
 * @author zhonghua.wu
 * @date 2019/6/16 15:46
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
abstract class AbstractSingleDeviceRequest extends AbstractDeviceRequest {

    private String orgId;
    private String assetId;
    private String productKey;
    private String deviceKey;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> map = new HashMap<>(5);
        map.put("action", action());
        if (orgId != null) {
            map.put("orgId", orgId);
        }
        if (assetId != null) {
            map.put("assetId", assetId);
        }
        if (productKey != null) {
            map.put("productKey", productKey);
        }
        if (deviceKey != null) {
            map.put("deviceKey", deviceKey);
        }
        return map;
    }

}
